/*
 * Decompiled with CFR 0.152.
 */
package de.linusdev.lutils.nat.array;

import de.linusdev.lutils.nat.NativeType;
import de.linusdev.lutils.nat.array.NativePrimitiveTypeArray;
import de.linusdev.lutils.nat.struct.annos.StructValue;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.Range;

public class NativeInt64Array
extends NativePrimitiveTypeArray<Long> {
    public static NativePrimitiveTypeArray.PrimitiveArrayStaticGenerator GENERATOR = new NativePrimitiveTypeArray.PrimitiveArrayStaticGenerator(NativeType.INT64);

    public static NativeInt64Array newUnallocated() {
        return new NativeInt64Array(null, false);
    }

    public static NativeInt64Array newAllocatable(@NotNull StructValue structValue) {
        return new NativeInt64Array(structValue, true);
    }

    public static NativeInt64Array newAllocated(@NotNull StructValue structValue) {
        NativeInt64Array ret = NativeInt64Array.newAllocatable(structValue);
        ret.allocate();
        return ret;
    }

    protected NativeInt64Array(@Nullable StructValue structValue, boolean generateInfo) {
        super(structValue, generateInfo, GENERATOR);
    }

    @Override
    public Long get(@Range(from=0L, to=0x7FFFFFFFL) int index) {
        return this.getLong(index);
    }

    public long getLong(@Range(from=0L, to=0x7FFFFFFFL) int index) {
        return this.byteBuf.getLong(this.positions.position(index));
    }

    @Override
    public void set(int index, Long item) {
        this.setLong(index, item);
    }

    public void setLong(int index, long item) {
        this.byteBuf.putLong(this.positions.position(index), item);
    }
}

