/*
 * Decompiled with CFR 0.152.
 */
package de.linusdev.lutils.nat.array;

import de.linusdev.lutils.nat.NativeType;
import de.linusdev.lutils.nat.array.NativePrimitiveTypeArray;
import de.linusdev.lutils.nat.struct.annos.StructValue;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.Range;

public class NativeInt8Array
extends NativePrimitiveTypeArray<Byte> {
    public static NativePrimitiveTypeArray.PrimitiveArrayStaticGenerator GENERATOR = new NativePrimitiveTypeArray.PrimitiveArrayStaticGenerator(NativeType.INT8);

    public static NativeInt8Array newUnallocated() {
        return new NativeInt8Array(null, false);
    }

    public static NativeInt8Array newAllocatable(@NotNull StructValue structValue) {
        return new NativeInt8Array(structValue, true);
    }

    public static NativeInt8Array newAllocated(@NotNull StructValue structValue) {
        NativeInt8Array ret = NativeInt8Array.newAllocatable(structValue);
        ret.allocate();
        return ret;
    }

    protected NativeInt8Array(@Nullable StructValue structValue, boolean generateInfo) {
        super(structValue, generateInfo, GENERATOR);
    }

    @Override
    public Byte get(@Range(from=0L, to=0x7FFFFFFFL) int index) {
        return this.getInt8(index);
    }

    public byte getInt8(@Range(from=0L, to=0x7FFFFFFFL) int index) {
        return this.byteBuf.get(this.positions.position(index));
    }

    @Override
    public void set(int index, Byte item) {
        this.setInt8(index, item);
    }

    public void setInt8(int index, byte item) {
        this.byteBuf.put(this.positions.position(index), item);
    }

    public void set(byte @NotNull [] value) {
        this.byteBuf.clear();
        this.byteBuf.put(value);
        this.byteBuf.clear();
    }
}

