/*
 * Decompiled with CFR 0.152.
 */
package de.linusdev.lutils.nat.memory.stack;

import de.linusdev.lutils.math.vector.buffer.intn.BBInt1;
import de.linusdev.lutils.math.vector.buffer.intn.BBUInt1;
import de.linusdev.lutils.nat.memory.DirectMemoryManager;
import de.linusdev.lutils.nat.memory.stack.PopPoint;
import de.linusdev.lutils.nat.memory.stack.SafePoint;
import de.linusdev.lutils.nat.pointer.BBPointer64;
import de.linusdev.lutils.nat.pointer.BBTypedPointer64;
import de.linusdev.lutils.nat.string.NullTerminatedUTF8String;
import de.linusdev.lutils.nat.struct.UStructSupplier;
import de.linusdev.lutils.nat.struct.abstracts.Structure;
import de.linusdev.lutils.nat.struct.annos.SVWrapper;
import de.linusdev.lutils.nat.struct.array.StructureArray;
import java.nio.ByteBuffer;
import org.jetbrains.annotations.NotNull;

public interface Stack
extends DirectMemoryManager {
    public <T extends Structure> T push(@NotNull T var1);

    public void pop();

    @NotNull
    public SafePoint safePoint();

    @NotNull
    public PopPoint popPoint();

    @NotNull
    default public BBUInt1 pushUnsignedInt() {
        return this.push(BBUInt1.newAllocatable(null));
    }

    @NotNull
    default public BBInt1 pushInt() {
        return this.push(BBUInt1.newAllocatable(null));
    }

    @NotNull
    default public NullTerminatedUTF8String pushString(@NotNull String string) {
        return this.push(NullTerminatedUTF8String.newAllocatable(string));
    }

    @NotNull
    default public <T extends Structure> StructureArray<T> pushArray(int size, @NotNull Class<?> elementClazz, @NotNull UStructSupplier<T> creator) {
        StructureArray<T> array = StructureArray.newAllocatable(false, SVWrapper.of(size, elementClazz), null, creator);
        return this.push(array);
    }

    @NotNull
    default public BBPointer64 pushPointer() {
        return this.push(BBPointer64.newAllocatable(null));
    }

    default public <T extends Structure> BBTypedPointer64<T> pushTypedPointer() {
        return this.push(BBTypedPointer64.newAllocatable1(null));
    }

    @NotNull
    public ByteBuffer pushByteBuffer(int var1, int var2);
}

