/*
 * Decompiled with CFR 0.152.
 */
package de.linusdev.lutils.nat.pointer;

import de.linusdev.lutils.nat.NativeParsable;
import de.linusdev.lutils.nat.pointer.Pointer64Impl;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public interface Pointer64 {
    public static final long NULL_POINTER = 0L;

    @Contract
    public static boolean requireNotNull(long pointer, @NotNull String message) {
        if (pointer == 0L) {
            throw new IllegalArgumentException(message);
        }
        return true;
    }

    @NotNull
    public static Pointer64 of(long pointer) {
        return new Pointer64Impl(pointer);
    }

    @NotNull
    public static Pointer64 of(@Nullable NativeParsable obj) {
        return new Pointer64Impl(Pointer64.refL(obj));
    }

    public static long refL(@Nullable NativeParsable obj) {
        return obj == null ? 0L : obj.getPointer();
    }

    public long get();

    public void set(long var1);

    default public boolean isNullPtr() {
        return this.get() == 0L;
    }
}

