/*
 * Decompiled with CFR 0.152.
 */
package de.linusdev.lutils.nat.string;

import de.linusdev.lutils.nat.array.NativeInt16Array;
import de.linusdev.lutils.nat.struct.annos.StructValue;
import java.nio.charset.StandardCharsets;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class NullTerminatedUTF16String
extends NativeInt16Array {
    public static NullTerminatedUTF16String newUnallocated() {
        return new NullTerminatedUTF16String(null, false);
    }

    public static NullTerminatedUTF16String newAllocatable(@NotNull StructValue structValue) {
        return new NullTerminatedUTF16String(structValue, true);
    }

    public static NullTerminatedUTF16String newAllocated(@NotNull StructValue structValue) {
        NullTerminatedUTF16String ret = NullTerminatedUTF16String.newAllocatable(structValue);
        ret.allocate();
        return ret;
    }

    protected NullTerminatedUTF16String(@Nullable StructValue structValue, boolean generateInfo) {
        super(structValue, generateInfo);
    }

    public void set(@NotNull String value) {
        this.byteBuf.clear();
        this.byteBuf.put(value.getBytes(StandardCharsets.UTF_16));
        this.byteBuf.put((byte)0);
        this.byteBuf.put((byte)0);
        this.byteBuf.clear();
    }

    @NotNull
    public String get() {
        this.byteBuf.clear();
        byte[] bytes = new byte[this.length()];
        this.byteBuf.get(bytes);
        int index = 0;
        for (int i = 0; i < bytes.length; ++i) {
            if (bytes[i] != 0 || bytes[i + 1] != 0) continue;
            index = i;
            break;
        }
        return new String(bytes, 0, index, StandardCharsets.UTF_16);
    }

    @Override
    public String toString() {
        return this.toString("utf-16-string", this.get());
    }
}

