/*
 * Decompiled with CFR 0.152.
 */
package de.linusdev.lutils.nat.struct.array;

import de.linusdev.lutils.nat.array.NativeArray;
import de.linusdev.lutils.nat.struct.abstracts.Structure;
import java.nio.ByteBuffer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Range;

public class NativeArrayView<T extends Structure>
implements NativeArray<T> {
    @NotNull
    private final NativeArray<T> original;
    @NotNull
    private final ByteBuffer backingBuffer;
    private final int offset;
    private final int length;

    public NativeArrayView(@NotNull NativeArray<T> original, @NotNull ByteBuffer backingBuffer, int offset, int length) {
        this.original = original;
        this.backingBuffer = backingBuffer;
        this.offset = offset;
        this.length = length;
    }

    @Override
    public T get(@Range(from=0L, to=0x7FFFFFFFL) int index) {
        return (T)((Structure)this.original.get(this.offset + index));
    }

    @Override
    public void set(int index, T item) {
        this.original.set(this.offset + index, item);
    }

    @Override
    public int length() {
        return this.length;
    }

    @Override
    public boolean isInitialised() {
        return this.original.isInitialised();
    }

    @Override
    public ByteBuffer getByteBuffer() {
        return this.backingBuffer;
    }

    @Override
    public int getRequiredSize() {
        return this.backingBuffer.capacity();
    }

    @Override
    public int getAlignment() {
        return this.original.getAlignment();
    }
}

