/*
 * Decompiled with CFR 0.152.
 */
package de.linusdev.lutils.nat.struct.array;

import de.linusdev.lutils.nat.abi.ABI;
import de.linusdev.lutils.nat.abi.OverwriteChildABI;
import de.linusdev.lutils.nat.array.NativeArray;
import de.linusdev.lutils.nat.struct.UStructSupplier;
import de.linusdev.lutils.nat.struct.abstracts.Structure;
import de.linusdev.lutils.nat.struct.annos.ElementsStructValueWrapper;
import de.linusdev.lutils.nat.struct.annos.RequirementType;
import de.linusdev.lutils.nat.struct.annos.SVWrapper;
import de.linusdev.lutils.nat.struct.annos.StructValue;
import de.linusdev.lutils.nat.struct.annos.StructureSettings;
import de.linusdev.lutils.nat.struct.array.NativeArrayView;
import de.linusdev.lutils.nat.struct.array.StructureArrayInfo;
import de.linusdev.lutils.nat.struct.generator.Language;
import de.linusdev.lutils.nat.struct.generator.StaticGenerator;
import de.linusdev.lutils.nat.struct.generator.StructCodeGenerator;
import de.linusdev.lutils.nat.struct.info.ArrayInfo;
import de.linusdev.lutils.nat.struct.info.StructureInfo;
import de.linusdev.lutils.nat.struct.mod.ModTrackingStructure;
import de.linusdev.lutils.nat.struct.utils.BufferUtils;
import de.linusdev.lutils.nat.struct.utils.SSMUtils;
import de.linusdev.lutils.nat.struct.utils.Utils;
import java.util.Iterator;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@StructureSettings(requiresCalculateInfoMethod=true, customLengthOption=RequirementType.REQUIRED, customElementTypesOption=RequirementType.REQUIRED, customLayoutOption=RequirementType.OPTIONAL)
public class StructureArray<T extends Structure>
extends ModTrackingStructure
implements NativeArray<T> {
    @NotNull
    public static final StaticGenerator GENERATOR = new StaticGenerator(){

        @Override
        @NotNull
        public StructureInfo calculateInfo(@NotNull Class<?> selfClazz, @Nullable StructValue structValue, @NotNull @NotNull StructValue @NotNull [] elementsStructValue, @NotNull ABI abi, @Nullable OverwriteChildABI overwriteChildAbi) {
            assert (structValue != null);
            StructureInfo elementInfo = SSMUtils.getInfo(structValue.elementType()[0], elementsStructValue.length == 0 ? null : elementsStructValue[0], null, abi, overwriteChildAbi, null, null);
            ArrayInfo info = abi.calculateArrayLayout(false, elementInfo, structValue.length()[0], -1);
            return new StructureArrayInfo(info.getAlignment(), info.isCompressed(), info.getRequiredSize(), info.getSizes(), info.getLength(), info.getStride(), info.getPositions(), structValue.elementType()[0], elementInfo);
        }

        @Override
        @NotNull
        public StructCodeGenerator codeGenerator() {
            return new StructCodeGenerator(){

                @Override
                @NotNull
                public String getStructTypeName(@NotNull Language language, @NotNull Class<?> selfClazz, @NotNull StructureInfo info) {
                    StructureArrayInfo arrayInfo = (StructureArrayInfo)info;
                    StructureInfo elementInfo = arrayInfo.elementInfo;
                    StaticGenerator elementGenerator = SSMUtils.getGenerator(arrayInfo.elementClass, null);
                    return elementGenerator.codeGenerator().getStructTypeName(language, arrayInfo.elementClass, elementInfo) + "[]";
                }

                @Override
                @NotNull
                public String getStructVarDef(@NotNull Language language, @NotNull Class<?> selfClazz, @NotNull StructureInfo info, @NotNull String varName) {
                    StructureArrayInfo arrayInfo = (StructureArrayInfo)info;
                    StructureInfo elementInfo = arrayInfo.elementInfo;
                    StaticGenerator elementGenerator = SSMUtils.getGenerator(arrayInfo.elementClass, null);
                    return elementGenerator.codeGenerator().getStructTypeName(language, arrayInfo.elementClass, elementInfo) + " " + varName + "[" + arrayInfo.getLength() + "]" + language.lineEnding;
                }
            };
        }
    };
    @NotNull
    private final UStructSupplier<T> creator;
    private ArrayInfo.ArrayPositionFunction positions;
    private StructureInfo elementInfo;
    private Structure[] items;
    private int size;

    @NotNull
    public static <T extends Structure> StructureArray<T> newUnallocated(boolean trackModifications, @NotNull UStructSupplier<T> creator) {
        return new StructureArray<T>(trackModifications, creator);
    }

    @NotNull
    public static <T extends Structure> StructureArray<T> newAllocated(boolean trackModifications, @NotNull StructValue structValue, @Nullable StructValue elementStructValue, @NotNull UStructSupplier<T> creator) {
        StructureArray<T> struct = new StructureArray<T>(trackModifications, structValue, elementStructValue, creator);
        struct.allocate();
        return struct;
    }

    @NotNull
    public static <T extends Structure> StructureArray<T> newAllocated(int length, Class<?> elementClass, @NotNull UStructSupplier<T> creator) {
        return StructureArray.newAllocated(false, SVWrapper.of(length, elementClass), null, creator);
    }

    @NotNull
    public static <T extends Structure> StructureArray<T> newAllocatable(boolean trackModifications, @NotNull StructValue structValue, @Nullable StructValue elementStructValue, @NotNull UStructSupplier<T> creator) {
        return new StructureArray<T>(trackModifications, structValue, elementStructValue, creator);
    }

    @NotNull
    public static <T extends Structure> StructureArray<T> ofPointer(boolean trackModifications, @NotNull Class<?> elementClazz, int length, long pointer, @NotNull UStructSupplier<T> creator) {
        StructureArray<T> sArray = StructureArray.newAllocatable(trackModifications, SVWrapper.of(length, elementClazz), null, creator);
        sArray.claimBuffer(BufferUtils.getByteBufferFromPointer(pointer, sArray.getRequiredSize()));
        return sArray;
    }

    protected StructureArray(boolean trackModifications, @NotNull UStructSupplier<T> creator) {
        super(trackModifications);
        this.creator = creator;
    }

    protected StructureArray(boolean trackModifications, @NotNull StructValue structValue, @Nullable StructValue elementStructValue, @NotNull UStructSupplier<T> creator) {
        super(trackModifications);
        this.setInfo(SSMUtils.getInfo(this.getClass(), structValue, elementStructValue == null ? null : new ElementsStructValueWrapper(new StructValue[]{elementStructValue}), null, null, null, GENERATOR));
        this.elementInfo = this.getInfo().elementInfo;
        this.size = this.getInfo().getLength();
        this.items = new Structure[this.size];
        this.creator = creator;
    }

    @Override
    public void set(int index, @NotNull T struct) {
        this.items[index] = struct;
        this.callUseBufferOf((Structure)struct, this.mostParentStructure, this.offset + this.positions.position(index), this.elementInfo);
    }

    @Override
    protected void useBuffer(@NotNull Structure mostParentStructure, int offset, @NotNull StructureInfo info) {
        super.useBuffer(mostParentStructure, offset, info);
        StructureArrayInfo aInfo = this.getInfo();
        this.elementInfo = aInfo.elementInfo;
        this.size = aInfo.getLength();
        this.items = new Structure[this.size];
    }

    @Override
    @NotNull
    public StructureArrayInfo getInfo() {
        return (StructureArrayInfo)super.getInfo();
    }

    @Override
    protected void onSetInfo(@NotNull StructureInfo info) {
        super.onSetInfo(info);
        this.positions = ((ArrayInfo)info).getPositions();
    }

    @Override
    public int length() {
        return this.size;
    }

    @Override
    @NotNull
    public T get(int index) {
        if (this.items[index] == null) {
            this.items[index] = this.creator.supply();
            T item = this.items[index];
            this.callUseBufferOf((Structure)item, this.mostParentStructure, this.offset + this.positions.position(index), this.elementInfo);
            return item;
        }
        return (T)this.items[index];
    }

    public T getOrNull(int index) {
        return (T)this.items[index];
    }

    @NotNull
    public NativeArrayView<T> getView(int startIndex, int length) {
        int byteIndex = this.positions.position(startIndex);
        return new NativeArrayView(this, this.byteBuf.slice(byteIndex, this.positions.position(startIndex + length) - byteIndex), startIndex, length);
    }

    @Override
    @NotNull
    public Iterator<T> iterator() {
        return new Iterator<T>(){
            int index = 0;

            @Override
            public boolean hasNext() {
                return this.index < StructureArray.this.length();
            }

            @Override
            public T next() {
                return StructureArray.this.get(this.index++);
            }
        };
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("length=").append(this.length()).append("\n");
        sb.append("stride=").append(this.getInfo().getStride()).append("\n");
        sb.append("items={\n");
        int index = 0;
        for (Structure item : this.items) {
            sb.append(Utils.indent(index + " (offsetStart=" + (this.offset + this.positions.position(index++)) + "): " + item, "    ")).append(",\n");
        }
        sb.append("}");
        return this.toString("StructureArray<" + this.getInfo().elementClass.getSimpleName() + ">", sb.toString());
    }
}

