/*
 * Decompiled with CFR 0.152.
 */
package de.linusdev.lutils.nat.struct.info;

import de.linusdev.lutils.nat.abi.ABI;
import de.linusdev.lutils.nat.abi.OverwriteChildABI;
import de.linusdev.lutils.nat.struct.abstracts.ComplexStructure;
import de.linusdev.lutils.nat.struct.abstracts.StructVarUtils;
import de.linusdev.lutils.nat.struct.abstracts.Structure;
import de.linusdev.lutils.nat.struct.info.StructVarInfo;
import de.linusdev.lutils.nat.struct.info.StructureInfo;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ComplexStructureInfo
extends StructureInfo {
    @NotNull
    protected final ABI abi;
    @NotNull
    protected final @NotNull StructVarInfo @NotNull [] childrenInfo;

    @NotNull
    public static ComplexStructureInfo generateFromStructVars(@NotNull Class<?> clazz, @NotNull ABI abi, @Nullable OverwriteChildABI overwriteChildAbi) {
        return StructVarUtils.getStructVars(clazz, abi, overwriteChildAbi, (varInfos, infos) -> {
            StructureInfo info = abi.calculateStructureLayout(false, infos);
            return new ComplexStructureInfo(info.getAlignment(), info.isCompressed(), info.getRequiredSize(), info.getSizes(), abi, varInfos);
        });
    }

    private ComplexStructureInfo(int alignment, boolean compress, int size, int[] sizes, @NotNull ABI abi, @NotNull @NotNull StructVarInfo @NotNull [] infos) {
        super(alignment, compress, size, sizes);
        this.abi = abi;
        this.childrenInfo = infos;
    }

    @NotNull
    public ABI getABI() {
        return this.abi;
    }

    @NotNull
    public @NotNull StructVarInfo @NotNull [] getChildrenInfo() {
        return this.childrenInfo;
    }

    @NotNull
    public @NotNull Structure @NotNull [] getChildren(@NotNull ComplexStructure instance) {
        Structure[] structures = new Structure[this.childrenInfo.length];
        for (int i = 0; i < structures.length; ++i) {
            structures[i] = this.childrenInfo[i].get(instance);
        }
        return structures;
    }
}

