/*
 * Decompiled with CFR 0.152.
 */
package de.linusdev.lutils.nat.struct.info;

import de.linusdev.lutils.nat.MemorySizeable;
import org.jetbrains.annotations.NotNull;

public class StructureInfo
implements MemorySizeable {
    protected final int alignment;
    protected final boolean compressed;
    protected final int size;
    protected final int @NotNull [] sizes;

    public StructureInfo(int alignment, boolean compressed, int prePadding, int size, int postPadding) {
        this.alignment = alignment;
        this.compressed = compressed;
        this.sizes = new int[]{prePadding, size, postPadding};
        this.size = prePadding + size + postPadding;
    }

    public StructureInfo(int alignment, boolean compressed, int size, int @NotNull [] sizes) {
        this.alignment = alignment;
        this.compressed = compressed;
        this.sizes = sizes;
        this.size = size;
    }

    @Override
    public int getRequiredSize() {
        return this.size;
    }

    @Override
    public int getAlignment() {
        return this.alignment;
    }

    public boolean isCompressed() {
        return this.compressed;
    }

    public int @NotNull [] getSizes() {
        return this.sizes;
    }

    public String toString() {
        StringBuilder ret = new StringBuilder(this.getClass().getSimpleName() + "(alignment= " + this.alignment + ", size=" + this.size + ", compressed=" + this.compressed + ") {\n");
        for (int i = 0; i < this.sizes.length; ++i) {
            if (i % 2 == 0 && this.sizes[i] != 0) {
                ret.append("\tpadding: ").append(this.sizes[i]).append(" bytes\n");
                continue;
            }
            if (i % 2 != 1) continue;
            ret.append("\titem: ").append(this.sizes[i]).append(" bytes\n");
        }
        return ret + "}";
    }
}

