/*
 * Decompiled with CFR 0.152.
 */
package de.linusdev.lutils.nat.struct.mod;

import de.linusdev.lutils.nat.struct.abstracts.Structure;
import de.linusdev.lutils.nat.struct.info.StructureInfo;
import de.linusdev.lutils.nat.struct.mod.ModificationInfo;
import java.nio.ByteBuffer;
import java.util.concurrent.locks.ReentrantLock;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class ModTrackingStructure
extends Structure {
    protected final boolean trackModifications;
    protected ReentrantLock modificationLock;
    protected final int modificationSplitOffset = 128;
    protected ModificationInfo modInfo = null;

    protected ModTrackingStructure(boolean trackModifications) {
        this.trackModifications = trackModifications;
    }

    @Override
    protected void useBuffer(@NotNull Structure mostParentStructure, int offset, @NotNull StructureInfo info) {
        super.useBuffer(mostParentStructure, offset, info);
    }

    @Override
    public void claimBuffer(@NotNull ByteBuffer buffer) {
        super.claimBuffer(buffer);
        this.modificationLock = new ReentrantLock();
    }

    @Override
    protected void onModification(int offset, int size) {
        if (this.trackModifications) {
            this.modificationLock.lock();
            int offsetEnd = offset + size;
            if (this.modInfo == null) {
                this.modInfo = new ModificationInfo(offset, offsetEnd);
            } else {
                this.modInfo.add(offset, offsetEnd, 128, null);
                if (this.modInfo.previous != null) {
                    this.modInfo = this.modInfo.previous;
                }
            }
            this.modificationLock.unlock();
        }
        super.onModification(offset, size);
    }

    @ApiStatus.Internal
    @Nullable
    public ModificationInfo getFirstModificationInfo(boolean clear) {
        ModificationInfo ret = this.modInfo;
        if (clear) {
            this.modInfo = null;
        }
        return ret;
    }

    public boolean tracksModifications() {
        return this.trackModifications;
    }

    public boolean handleModifications(@NotNull ModificationsHandler handler) {
        if (!this.isModified()) {
            return false;
        }
        this.unmodified();
        if (!this.tracksModifications()) {
            handler.handle(new ModificationInfo(0, this.getRequiredSize()));
            return true;
        }
        this.modificationLock.lock();
        try {
            ModificationInfo first = this.getFirstModificationInfo(true);
            while (first != null) {
                handler.handle(first);
                first = first.next;
            }
        }
        finally {
            this.modificationLock.unlock();
        }
        return true;
    }

    public static interface ModificationsHandler {
        public void handle(@NotNull ModificationInfo var1);
    }
}

