/*
 * Decompiled with CFR 0.152.
 */
package de.linusdev.lutils.net.http;

import de.linusdev.lutils.net.http.HTTPMessageReader;
import de.linusdev.lutils.net.http.header.Header;
import de.linusdev.lutils.net.http.header.HeaderMap;
import de.linusdev.lutils.net.http.version.HTTPVersion;
import java.io.IOException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class HTTPMessage<B> {
    @NotNull
    protected final HTTPVersion version;
    @NotNull
    protected final HeaderMap headers;
    @Nullable
    protected final B body;

    protected static HeaderMap parseHeaders(@NotNull HTTPMessageReader reader) throws IOException {
        String key;
        HeaderMap headers = new HeaderMap();
        HTTPMessageReader.LineReader lineReader = reader.getLineReader();
        while (!lineReader.eof && !(key = lineReader.readUntil(':')).isEmpty()) {
            if (lineReader.eol) {
                throw new IllegalArgumentException("Malformed HTTP request. Header line: " + key);
            }
            String value = lineReader.readUntilLineFeed().stripLeading();
            Header header = Header.of(key, value);
            headers.put(key, header);
        }
        return headers;
    }

    protected HTTPMessage(@NotNull HTTPVersion version, @NotNull HeaderMap headers, @Nullable B body) {
        this.version = version;
        this.headers = headers;
        this.body = body;
    }

    @NotNull
    public HTTPVersion getVersion() {
        return this.version;
    }

    @NotNull
    public HeaderMap getHeaders() {
        return this.headers;
    }

    @Nullable
    public B getBody() {
        return this.body;
    }
}

