/*
 * Decompiled with CFR 0.152.
 */
package de.linusdev.lutils.net.http;

import de.linusdev.lutils.net.http.HTTPMessage;
import de.linusdev.lutils.net.http.HTTPMessageBuilder;
import de.linusdev.lutils.net.http.HTTPMessageReader;
import de.linusdev.lutils.net.http.body.BodyParser;
import de.linusdev.lutils.net.http.header.HeaderMap;
import de.linusdev.lutils.net.http.method.RequestMethod;
import de.linusdev.lutils.net.http.path.PathAndQuery;
import de.linusdev.lutils.net.http.version.HTTPVersion;
import de.linusdev.lutils.net.http.version.HTTPVersions;
import java.io.IOException;
import java.io.InputStream;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class HTTPRequest<B>
extends HTTPMessage<B> {
    @NotNull
    private final RequestMethod method;
    @Nullable
    private final String path;

    public HTTPRequest(@NotNull RequestMethod method, @Nullable String path, @NotNull HTTPVersion version, @NotNull HeaderMap headers, @Nullable B body) {
        super(version, headers, body);
        this.method = method;
        this.path = path;
    }

    @NotNull
    public static <B> HTTPRequest<B> parse(@NotNull InputStream in, @NotNull BodyParser<B> parser) throws IOException {
        HTTPVersion version;
        String path;
        HTTPMessageReader reader = new HTTPMessageReader(in);
        HTTPMessageReader.LineReader lineReader = reader.getLineReader();
        RequestMethod method = RequestMethod.of(lineReader.readUntil(' '));
        if (lineReader.eol) {
            throw new IllegalArgumentException("Malformed HTTP request. Missing HTTP version.");
        }
        String pathOrVersion = lineReader.readUntil(' ');
        if (lineReader.eol) {
            path = null;
            version = HTTPVersions.of(pathOrVersion);
        } else {
            path = pathOrVersion;
            version = HTTPVersions.of(lineReader.readUntilLineFeed());
        }
        HeaderMap headers = HTTPRequest.parseHeaders(reader);
        B body = parser.parse(headers, reader.getInputStreamForRemaining());
        return new HTTPRequest<B>(method, path, version, headers, body);
    }

    @NotNull
    public static HTTPRequest<InputStream> parse(@NotNull InputStream in) throws IOException {
        return HTTPRequest.parse(in, (hs, in1) -> in1);
    }

    @NotNull
    public static HTTPMessageBuilder builder() {
        return new HTTPMessageBuilder();
    }

    @NotNull
    public RequestMethod getMethod() {
        return this.method;
    }

    @Nullable
    public String getPathAndQueryAsString() {
        return this.path;
    }

    @Nullable
    public PathAndQuery getPathAndQuery() {
        return this.path == null ? null : new PathAndQuery(this.path);
    }
}

