/*
 * Decompiled with CFR 0.152.
 */
package de.linusdev.lutils.net.http.body;

import de.linusdev.lutils.net.http.header.HeaderMap;
import de.linusdev.lutils.net.http.header.HeaderNames;
import de.linusdev.lutils.net.http.header.contenttype.ContentType;
import java.io.IOException;
import java.io.InputStream;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public interface Body {
    @Nullable
    public ContentType contentType();

    public long length();

    default public long definitiveLength() {
        long l;
        block10: {
            if (this.length() != -1L) {
                return this.length();
            }
            InputStream stream = this.stream();
            try {
                int len;
                byte[] buffer = new byte[2048];
                long actualLength = 0L;
                while ((len = stream.read(buffer)) != -1) {
                    actualLength += (long)len;
                }
                l = actualLength;
                if (stream == null) break block10;
            }
            catch (Throwable throwable) {
                try {
                    if (stream != null) {
                        try {
                            stream.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    throw new IllegalStateException("Cannot calculate length of this body.", e);
                }
            }
            stream.close();
        }
        return l;
    }

    default public void adjustHeaders(@NotNull HeaderMap headers) {
        ContentType contentType = this.contentType();
        if (contentType != null) {
            headers.put(contentType.asHeader());
        }
        headers.put(HeaderNames.CONTENT_LENGTH.with("" + this.definitiveLength()));
    }

    default public void removeHeaders(@NotNull HeaderMap headers) {
        ContentType contentType = this.contentType();
        if (contentType != null && headers.containsValue(contentType.asHeader())) {
            headers.remove(HeaderNames.CONTENT_TYPE);
        }
        if (headers.containsValue(HeaderNames.CONTENT_LENGTH.with("" + this.length()))) {
            headers.remove(HeaderNames.CONTENT_LENGTH);
        }
    }

    @NotNull
    public InputStream stream() throws IOException;
}

