/*
 * Decompiled with CFR 0.152.
 */
package de.linusdev.lutils.net.http.status;

import de.linusdev.lutils.net.http.status.ResponseStatusCodeType;
import java.util.HashMap;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public interface ResponseStatusCode {
    @NotNull
    public static final Map<Integer, ResponseStatusCode> STATUS_CODES = new HashMap<Integer, ResponseStatusCode>();

    @NotNull
    public static ResponseStatusCode of(final int statusCode, final @Nullable String name) {
        ResponseStatusCode ret = STATUS_CODES.get(statusCode);
        if (ret != null && ret.getName().equals(name)) {
            return ret;
        }
        return new ResponseStatusCode(){

            @Override
            public int getStatusCode() {
                return statusCode;
            }

            @Override
            @NotNull
            public String getName() {
                return name == null ? "" : name;
            }
        };
    }

    @NotNull
    public static ResponseStatusCode of(@NotNull String statusCode, @Nullable String name) {
        try {
            return ResponseStatusCode.of(Integer.parseInt(statusCode), name);
        }
        catch (NumberFormatException e) {
            throw new IllegalArgumentException("Status code must be an integer, but was: '" + statusCode + "'", e);
        }
    }

    public static boolean equals(@NotNull ResponseStatusCode first, @NotNull ResponseStatusCode second) {
        return first == second || first.getStatusCode() == second.getStatusCode();
    }

    @NotNull
    default public ResponseStatusCodeType getType() {
        return ResponseStatusCodeType.of(this.getStatusCode());
    }

    public int getStatusCode();

    @NotNull
    public String getName();
}

