/*
 * Decompiled with CFR 0.152.
 */
package de.linusdev.lutils.net.routing;

import de.linusdev.lutils.net.http.HTTPMessageBuilder;
import de.linusdev.lutils.net.http.HTTPRequest;
import de.linusdev.lutils.net.http.HTTPResponse;
import de.linusdev.lutils.net.http.body.Bodies;
import de.linusdev.lutils.net.http.body.UnparsedBody;
import de.linusdev.lutils.net.http.status.StatusCodes;
import de.linusdev.lutils.net.routing.RoutingState;
import java.io.IOException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public interface RequestHandler {
    @NotNull
    public static RequestHandler ofHtmlResource(@Nullable Class<?> clazz, @NotNull String name) {
        return request -> HTTPResponse.builder().setStatusCode(StatusCodes.OK).setBody(Bodies.html().ofResource(clazz, name));
    }

    @NotNull
    public static RequestHandler ofHtmlResource(@NotNull String name) {
        return RequestHandler.ofHtmlResource(null, name);
    }

    @NotNull
    public static RequestHandler ofCssResource(@Nullable Class<?> clazz, @NotNull String name) {
        return request -> HTTPResponse.builder().setStatusCode(StatusCodes.OK).setBody(Bodies.css().ofResource(clazz, name));
    }

    @NotNull
    public static RequestHandler ofCssResource(@NotNull String name) {
        return RequestHandler.ofCssResource(null, name);
    }

    @NotNull
    public static RequestHandler ofJsResource(@Nullable Class<?> clazz, @NotNull String name) {
        return request -> HTTPResponse.builder().setStatusCode(StatusCodes.OK).setBody(Bodies.javascript().ofResource(clazz, name));
    }

    @NotNull
    public static RequestHandler ofJsResource(@NotNull String name) {
        return RequestHandler.ofJsResource(null, name);
    }

    @Nullable
    public HTTPMessageBuilder handle(@NotNull HTTPRequest<UnparsedBody> var1);

    @Nullable
    default public HTTPMessageBuilder handle(@NotNull RoutingState state) throws IOException {
        return this.handle(state.getRequest());
    }
}

