/*
 * Decompiled with CFR 0.152.
 */
package de.linusdev.lutils.net.routing;

import de.linusdev.lutils.net.http.HTTPRequest;
import de.linusdev.lutils.net.http.body.UnparsedBody;
import de.linusdev.lutils.net.http.method.RequestMethod;
import java.net.Socket;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class RoutingState {
    @Nullable
    private final Socket socket;
    @NotNull
    private final HTTPRequest<UnparsedBody> request;
    @NotNull
    private final String[] path;
    private int pathIndex = 0;
    private boolean handled = false;

    public RoutingState(@Nullable Socket socket, @NotNull HTTPRequest<UnparsedBody> request, @NotNull String path) {
        this.socket = socket;
        this.request = request;
        if (path.startsWith("/")) {
            path = path.substring(1);
        }
        if (path.endsWith("/")) {
            path = path.substring(0, path.length() - 1);
        }
        this.path = path.split("/");
    }

    public boolean isAnotherPathPartAvailable() {
        return this.pathIndex < this.path.length;
    }

    @NotNull
    public String getNextPathPart() {
        return this.path[this.pathIndex++];
    }

    @NotNull
    public HTTPRequest<UnparsedBody> getRequest() {
        return this.request;
    }

    @NotNull
    public RequestMethod getMethod() {
        return this.request.getMethod();
    }

    @Nullable
    public Socket getSocket() {
        return this.socket;
    }

    public void handled() {
        this.handled = true;
    }

    public boolean isHandled() {
        return this.handled;
    }
}

