/*
 * Decompiled with CFR 0.152.
 */
package de.linusdev.lutils.net.server;

import de.linusdev.lutils.async.Future;
import de.linusdev.lutils.async.Nothing;
import de.linusdev.lutils.async.Task;
import de.linusdev.lutils.async.completeable.CompletableFuture;
import de.linusdev.lutils.async.completeable.CompletableTask;
import de.linusdev.lutils.async.exception.NonBlockingThreadException;
import de.linusdev.lutils.async.manager.AsyncManager;
import de.linusdev.lutils.interfaces.ExceptionHandler;
import de.linusdev.lutils.net.routing.Routing;
import java.awt.Desktop;
import java.io.IOException;
import java.net.ServerSocket;
import java.net.URI;
import java.net.URISyntaxException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SimpleHttpServer
implements AsyncManager {
    @NotNull
    private final ServerSocket serverSocket;
    private final ExceptionHandler exceptionHandler;
    @NotNull
    private final CompletableFuture<Nothing, SimpleHttpServer, CompletableTask<Nothing, SimpleHttpServer>> closeFuture;
    private volatile boolean keepAlive = true;

    public SimpleHttpServer(int port, @NotNull Routing routing, @NotNull ExceptionHandler exceptionHandler) throws IOException {
        this.serverSocket = new ServerSocket(port, 3);
        this.exceptionHandler = exceptionHandler;
        this.closeFuture = CompletableFuture.create(this, false);
        Thread thread = new Thread(() -> {
            while (this.keepAlive) {
                try {
                    routing.route(this.serverSocket.accept());
                }
                catch (Throwable e) {
                    exceptionHandler.accept(e);
                }
            }
        }, "simple-http-server");
        thread.setDaemon(true);
        thread.start();
    }

    @NotNull
    public Future<Nothing, SimpleHttpServer> getCloseFuture() {
        return this.closeFuture;
    }

    public void shutdown() {
        try {
            this.closeFuture.complete(Nothing.INSTANCE, this, null);
            this.keepAlive = false;
            this.serverSocket.close();
        }
        catch (Throwable e) {
            this.exceptionHandler.accept(e);
        }
    }

    public void print() {
        System.out.println("SimpleHttpServer running on: http://localhost:" + this.serverSocket.getLocalPort());
    }

    public void openInBrowser(@NotNull String path) {
        if (Desktop.isDesktopSupported() && Desktop.getDesktop().isSupported(Desktop.Action.BROWSE)) {
            try {
                Desktop.getDesktop().browse(new URI("http://localhost:" + this.serverSocket.getLocalPort() + "/" + path));
            }
            catch (IOException | URISyntaxException exception) {
                // empty catch block
            }
        }
    }

    @Override
    public void checkThread() throws NonBlockingThreadException {
    }

    @Override
    public void onExceptionInListener(@NotNull Future<?, ?> future, @Nullable Task<?, ?> task, @NotNull Throwable throwable) {
        this.exceptionHandler.accept(throwable);
    }
}

