/*
 * Decompiled with CFR 0.152.
 */
package de.linusdev.lutils.net.ws;

import de.linusdev.lutils.interfaces.TRunnable;
import de.linusdev.lutils.io.InputStreamUtils;
import de.linusdev.lutils.net.ws.WebSocketListener;
import de.linusdev.lutils.net.ws.frame.Frame;
import de.linusdev.lutils.net.ws.frame.OpCodes;
import de.linusdev.lutils.net.ws.frames.writable.WritableEmptyFrame;
import de.linusdev.lutils.net.ws.frames.writable.WritableTextFrame;
import de.linusdev.lutils.net.ws.frames.writable.WriteableByteArrayFrame;
import de.linusdev.lutils.net.ws.frames.writable.WriteableFrame;
import de.linusdev.lutils.other.ByteUtils;
import java.io.Closeable;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.Socket;
import java.util.Random;
import org.jetbrains.annotations.NotNull;

public class WebSocket
implements Closeable {
    @NotNull
    private final Random RANDOM = new Random();
    @NotNull
    private final Socket socket;
    private final boolean allowUnmaskedIncomingMessages;
    private final boolean maskOutgoingMessages;
    @NotNull
    private final InputStream in;
    @NotNull
    private final OutputStream out;

    public WebSocket(@NotNull Socket socket, boolean allowUnmaskedIncomingMessages, boolean maskOutgoingMessages) throws IOException {
        this.socket = socket;
        this.in = socket.getInputStream();
        this.out = socket.getOutputStream();
        this.allowUnmaskedIncomingMessages = allowUnmaskedIncomingMessages;
        this.maskOutgoingMessages = maskOutgoingMessages;
    }

    @NotNull
    public WebSocketListener createListener(@NotNull WebSocketListener.Listener listener) {
        return new WebSocketListener(this, listener);
    }

    public boolean isAvailable() throws IOException {
        return this.in.available() > 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <E extends Throwable> void runSynchronisedReadable(@NotNull TRunnable<E> runnable) throws E {
        InputStream inputStream = this.in;
        synchronized (inputStream) {
            runnable.run();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <E extends Throwable> void runSynchronisedWritable(@NotNull TRunnable<E> runnable) throws E {
        OutputStream outputStream = this.out;
        synchronized (outputStream) {
            runnable.run();
        }
    }

    public void sendBinary(byte @NotNull [] payload) throws IOException {
        this.writeFrame(new WriteableByteArrayFrame(OpCodes.BINARY, payload));
    }

    public void sendText(@NotNull String text) throws IOException {
        this.writeFrame(new WritableTextFrame(text));
    }

    public void sendPing(@NotNull String text) throws IOException {
        this.writeFrame(new WritableTextFrame(OpCodes.PING, text));
    }

    public void sendPong(@NotNull String text) throws IOException {
        this.writeFrame(new WritableTextFrame(OpCodes.PONG, text));
    }

    public void sendPing(byte @NotNull [] payload) throws IOException {
        this.writeFrame(new WriteableByteArrayFrame(OpCodes.PING, payload));
    }

    public void sendPong(byte @NotNull [] payload) throws IOException {
        this.writeFrame(new WriteableByteArrayFrame(OpCodes.PONG, payload));
    }

    public void sendPing() throws IOException {
        this.writeFrame(new WritableEmptyFrame(OpCodes.PING));
    }

    public void sendPong() throws IOException {
        this.writeFrame(new WritableEmptyFrame(OpCodes.PONG));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void writeFrame(@NotNull WriteableFrame payload) throws IOException {
        OutputStream outputStream = this.out;
        synchronized (outputStream) {
            byte[] maskingKey = new byte[4];
            int payloadLength = payload.length();
            int b = 0;
            if (payload.isFinal()) {
                b = (byte)(b | 0xFFFFFF80);
            }
            b = (byte)(b | payload.opcode().getCode());
            this.out.write(b & 0xFF);
            b = 0;
            if (this.maskOutgoingMessages) {
                b = (byte)(b | 0xFFFFFF80);
            }
            if (payloadLength >= 126) {
                if (payloadLength <= 65535) {
                    b = (byte)(b | 0x7E);
                    this.out.write(b);
                } else {
                    b = (byte)(b | 0x7F);
                    this.out.write(b);
                    this.out.write((payloadLength & 0xFF000000) >>> 24);
                    this.out.write((payloadLength & 0xFF0000) >>> 16);
                }
                this.out.write((payloadLength & 0xFF00) >>> 8);
                this.out.write(payloadLength & 0xFF);
            } else {
                b = (byte)(b | (byte)payloadLength);
                this.out.write(b);
            }
            if (this.maskOutgoingMessages) {
                this.RANDOM.nextBytes(maskingKey);
                this.out.write(maskingKey[0]);
                this.out.write(maskingKey[1]);
                this.out.write(maskingKey[2]);
                this.out.write(maskingKey[3]);
            }
            if (payloadLength > 0) {
                try (InputStream in = payload.stream();){
                    if (in == null) {
                        throw new IllegalStateException("Payload length is not 0, but no stream is given.");
                    }
                    byte[] bytes = new byte[payloadLength];
                    if (!InputStreamUtils.readUntilArrayIsFull(in, bytes)) {
                        throw new IllegalStateException("Payload length is " + payloadLength + ", but actual length was smaller.");
                    }
                    this.out.write(bytes);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public Frame readFrame() throws IOException {
        InputStream inputStream = this.in;
        synchronized (inputStream) {
            byte[] maskingKey;
            byte b = this.readByte();
            boolean fin = (b & 0x80) > 0;
            boolean rsv1 = (b & 0x40) > 0;
            boolean rsv2 = (b & 0x20) > 0;
            boolean rsv3 = (b & 0x10) > 0;
            byte opcode = (byte)(b & 0xF);
            b = this.readByte();
            boolean mask = (b & 0x80) > 0;
            int payloadLength = this.readPayloadLength(b);
            byte[] byArray = maskingKey = mask ? this.readMaskingKey() : null;
            if (!this.allowUnmaskedIncomingMessages && !mask) {
                throw new IOException("Unmasked payloads are not supported.");
            }
            byte[] payload = new byte[payloadLength];
            if (maskingKey == null) {
                InputStreamUtils.readUntilArrayIsFull(this.in, payload);
            } else {
                int index = 0;
                while (index < payloadLength) {
                    int read = this.in.read();
                    if (read == -1) {
                        throw new EOFException("Unexpected EOF while reading payload.");
                    }
                    payload[index] = (byte)(((byte)read ^ maskingKey[index++ % 4]) & 0xFF);
                }
            }
            return new Frame(fin, rsv1, rsv2, rsv3, mask, opcode, payloadLength, payload);
        }
    }

    private int readPayloadLength(byte b) throws IOException {
        int payloadLength = b & 0x7F;
        if (payloadLength <= 125) {
            return payloadLength;
        }
        if (payloadLength == 126) {
            return ByteUtils.constructInt(this.readByte(), this.readByte());
        }
        return ByteUtils.constructInt(this.readByte(), this.readByte(), this.readByte(), this.readByte());
    }

    private byte[] readMaskingKey() throws IOException {
        return new byte[]{this.readByte(), this.readByte(), this.readByte(), this.readByte()};
    }

    private byte readByte() throws IOException {
        int i = this.in.read();
        if (i == -1) {
            throw new IOException("Unexpected EOF");
        }
        return (byte)i;
    }

    @Override
    public void close() throws IOException {
        this.socket.close();
    }

    public boolean isClosed() {
        return this.socket.isClosed();
    }
}

