/*
 * Decompiled with CFR 0.152.
 */
package org.dyvinia.explosionrebalance.mixin;

import net.minecraft.core.Holder;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.Explosion;
import net.minecraft.world.level.ExplosionDamageCalculator;
import net.minecraft.world.level.Level;
import org.dyvinia.explosionrebalance.util.ExplosionOptions;
import org.dyvinia.explosionrebalance.util.IEntityExplosionOptions;
import org.jetbrains.annotations.Nullable;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={Level.class})
public abstract class LevelMixin {
    @Inject(method={"explode(Lnet/minecraft/world/entity/Entity;Lnet/minecraft/world/damagesource/DamageSource;Lnet/minecraft/world/level/ExplosionDamageCalculator;DDDFZLnet/minecraft/world/level/Level$ExplosionInteraction;ZLnet/minecraft/core/particles/ParticleOptions;Lnet/minecraft/core/particles/ParticleOptions;Lnet/minecraft/core/Holder;)Lnet/minecraft/world/level/Explosion;"}, at={@At(value="HEAD")}, cancellable=true)
    private void overrideExplosion(@Nullable Entity pSource, @Nullable DamageSource pDamageSource, @Nullable ExplosionDamageCalculator pDamageCalculator, double pX, double pY, double pZ, float pRadius, boolean pFire, Level.ExplosionInteraction pExplosionInteraction, boolean pSpawnParticles, ParticleOptions pSmallExplosionParticles, ParticleOptions pLargeExplosionParticles, Holder<SoundEvent> pExplosionSound, CallbackInfoReturnable<Explosion> cir) {
        ExplosionOptions options = ExplosionOptions.from(pSource, Float.valueOf(pRadius));
        if (pSource == null || options == null) {
            return;
        }
        ((IEntityExplosionOptions)pSource).explosionRebalance$setExplosionOptions(options);
        if (!options.griefing()) {
            ParticleOptions particles = pRadius >= 2.0f ? pLargeExplosionParticles : pSmallExplosionParticles;
            Explosion explosion = new Explosion((Level)this, pSource, pDamageSource, pDamageCalculator, pX, pY, pZ, pRadius, false, Explosion.BlockInteraction.KEEP, particles, particles, pExplosionSound);
            explosion.explode();
            explosion.finalizeExplosion(pSpawnParticles);
            cir.setReturnValue((Object)explosion);
            cir.cancel();
        }
    }
}

