/*
 * Decompiled with CFR 0.152.
 */
package org.dyvinia.explosionrebalance.util;

import java.util.List;
import java.util.Optional;
import net.minecraft.class_1297;
import net.minecraft.class_1511;
import net.minecraft.class_1528;
import net.minecraft.class_1541;
import net.minecraft.class_1548;
import net.minecraft.class_1687;
import net.minecraft.class_1701;
import net.minecraft.class_3855;
import org.dyvinia.explosionrebalance.config.Config;
import org.jetbrains.annotations.Nullable;

public record ExplosionOptions(boolean griefing, boolean knockback, double knockbackMult, double damageMult, float radius) {
    public double knockbackStrength() {
        return (Double)Config.CONFIG.knockbackStrength.get() * this.knockbackMult;
    }

    public double playerKnockbackStrength() {
        return this.knockbackStrength() * (Double)Config.CONFIG.playerKnockbackMult.get();
    }

    public double upwardsKnockback() {
        return (Double)Config.CONFIG.upwardsKnockback.get();
    }

    public double falloffExponent() {
        return (Double)Config.CONFIG.falloffExponent.get();
    }

    public double falloffExtension() {
        return (Double)Config.CONFIG.falloffExtension.get();
    }

    public float damageMultiplier() {
        return (float)(this.damageMult > 0.0 ? this.damageMult : 0.01);
    }

    @Nullable
    public static ExplosionOptions from(@Nullable class_1297 ent) {
        return ExplosionOptions.from(ent, null);
    }

    @Nullable
    public static ExplosionOptions from(@Nullable class_1297 ent, @Nullable Float radius) {
        Optional<List> customExploder;
        if (ent instanceof class_1548) {
            class_1548 creeper = (class_1548)ent;
            return new ExplosionOptions((Boolean)Config.CONFIG.disableCreeperGriefing.get() == false, (Boolean)Config.CONFIG.enableCreeperKnockback.get(), (Double)Config.CONFIG.creeperKnockbackMult.get(), (Double)Config.CONFIG.creeperDamageMult.get(), Optional.ofNullable(radius).orElse(Float.valueOf((creeper.method_61492() ? 2.0f : 1.0f) * 3.0f)).floatValue());
        }
        if (ent instanceof class_1511) {
            return new ExplosionOptions((Boolean)Config.CONFIG.disableEndCrystalGriefing.get() == false, (Boolean)Config.CONFIG.enableEndCrystalKnockback.get(), (Double)Config.CONFIG.endCrystalKnockbackMult.get(), (Double)Config.CONFIG.endCrystalDamageMult.get(), Optional.ofNullable(radius).orElse(Float.valueOf(6.0f)).floatValue());
        }
        if (ent instanceof class_3855) {
            return new ExplosionOptions((Boolean)Config.CONFIG.disableFireballGriefing.get() == false, (Boolean)Config.CONFIG.enableFireballKnockback.get(), (Double)Config.CONFIG.fireballKnockbackMult.get(), (Double)Config.CONFIG.fireballDamageMult.get(), Optional.ofNullable(radius).orElse(Float.valueOf(1.0f)).floatValue());
        }
        if (ent instanceof class_1541 || ent instanceof class_1701) {
            return new ExplosionOptions((Boolean)Config.CONFIG.disableTNTGriefing.get() == false, (Boolean)Config.CONFIG.enableTNTKnockback.get(), (Double)Config.CONFIG.tntKnockbackMult.get(), (Double)Config.CONFIG.tntDamageMult.get(), Optional.ofNullable(radius).orElse(Float.valueOf(4.0f)).floatValue());
        }
        if (ent instanceof class_1528) {
            return new ExplosionOptions((Boolean)Config.CONFIG.disableWitherGriefing.get() == false, (Boolean)Config.CONFIG.enableWitherKnockback.get(), (Double)Config.CONFIG.witherKnockbackMult.get(), (Double)Config.CONFIG.witherDamageMult.get(), Optional.ofNullable(radius).orElse(Float.valueOf(7.0f)).floatValue());
        }
        if (ent instanceof class_1687) {
            return new ExplosionOptions((Boolean)Config.CONFIG.disableWitherSkullGriefing.get() == false, (Boolean)Config.CONFIG.enableWitherSkullKnockback.get(), (Double)Config.CONFIG.witherSkullKnockbackMult.get(), (Double)Config.CONFIG.witherSkullDamageMult.get(), Optional.ofNullable(radius).orElse(Float.valueOf(1.0f)).floatValue());
        }
        if (ent != null && !ent.method_5864().method_5882().isEmpty() && !((List)Config.CONFIG.customExplosions.get()).isEmpty() && !((List)((List)Config.CONFIG.customExplosions.get()).getFirst()).isEmpty() && (customExploder = ((List)Config.CONFIG.customExplosions.get()).stream().filter(o -> ent.method_5864().method_5882().equalsIgnoreCase((String)o.getFirst())).findFirst()).isPresent()) {
            return new ExplosionOptions((Boolean)customExploder.get().get(1) == false, (Boolean)customExploder.get().get(2), (Double)customExploder.get().get(3), (Double)customExploder.get().get(4), Optional.ofNullable(radius).orElse(Float.valueOf(3.0f)).floatValue());
        }
        return null;
    }
}

