/*
 * Decompiled with CFR 0.152.
 */
package com.mr_toad.palladium.api;

import com.google.common.collect.Sets;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import com.mr_toad.lib.mtjava.util.func.SelfFunction;
import com.mr_toad.palladium.core.Palladium;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Set;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.GoalSelector;
import net.minecraft.world.entity.ai.goal.WrappedGoal;

public interface GoalMapperProvider {
    public boolean canRun();

    public void run(Mob var1, ResourceLocation var2);

    default public void runIfCan(Mob entity, ResourceLocation location) {
        if (this.canRun()) {
            this.run(entity, location);
        }
    }

    default public boolean removeAllTasksOfClass(Mob entity, Class<?> classToRemove) {
        boolean found = false;
        Set availableGoals = entity.f_21345_.m_148105_();
        Iterator iterator = availableGoals.iterator();
        while (iterator.hasNext()) {
            WrappedGoal task = (WrappedGoal)iterator.next();
            if (task.m_26015_().getClass() != classToRemove) continue;
            found = true;
            iterator.remove();
        }
        return found;
    }

    @CanIgnoreReturnValue
    default public int tryAndReplaceAllTasks(Mob entity, GoalSelector goalSelector, Class<?> toMatch, SelfFunction<Goal> action) {
        int count = 0;
        LinkedHashSet newAvailableGoals = Sets.newLinkedHashSet();
        Set oldAvailableGoals = goalSelector.m_148105_();
        for (WrappedGoal entry : oldAvailableGoals) {
            if (toMatch == entry.m_26015_().getClass()) {
                Goal newAI = (Goal)action.apply((Object)entry.m_26015_());
                if (newAI != null) {
                    newAvailableGoals.add(new WrappedGoal(entry.m_26012_(), newAI));
                    ++count;
                    continue;
                }
                Palladium.LOGGER.warn("Failed replace {} to {}", (Object)entity.getClass().getName(), (Object)toMatch.getName());
                newAvailableGoals.add(entry);
                continue;
            }
            newAvailableGoals.add(entry);
        }
        if (count > 0) {
            oldAvailableGoals.clear();
            oldAvailableGoals.addAll(newAvailableGoals);
        }
        return count;
    }
}

