/*
 * Decompiled with CFR 0.152.
 */
package com.mr_toad.palladium.client.shader.gl;

import it.unimi.dsi.fastutil.objects.Reference2IntMap;
import it.unimi.dsi.fastutil.objects.Reference2IntOpenHashMap;
import java.util.Objects;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.lwjgl.opengl.GL20;

@OnlyIn(value=Dist.CLIENT)
public class GlUniform {
    private final int id;
    private final Reference2IntMap<CharSequence> uniforms = new Reference2IntOpenHashMap();

    public GlUniform(int id) {
        this.id = id;
    }

    public int uniform(CharSequence uniformName) {
        return this.uniforms.computeIfAbsent((Object)uniformName, value -> GL20.glGetUniformLocation((int)this.id, (CharSequence)uniformName));
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj.getClass() != this.getClass()) {
            return false;
        }
        if (obj instanceof GlUniform) {
            GlUniform cache = (GlUniform)obj;
            return Objects.equals(this.id, cache.id);
        }
        return false;
    }

    public int hashCode() {
        return 31 * this.id + this.uniforms.size();
    }

    public String toString() {
        return "GLUniform<" + this.id + ">";
    }
}

