/*
 * Decompiled with CFR 0.152.
 */
package com.mr_toad.palladium.common;

import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import java.util.concurrent.TimeUnit;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class Deduplicator<T> {
    private final Cache<T, T> cache;
    private int attemptedInsertions = 0;
    private int deduplicated = 0;

    public Deduplicator(int size, int duration, TimeUnit timeUnit) {
        this.cache = CacheBuilder.newBuilder().maximumSize((long)size).expireAfterWrite((long)duration, timeUnit).build();
    }

    public synchronized T deduplicate(T item) {
        ++this.attemptedInsertions;
        Object cachedItem = this.cache.getIfPresent(item);
        if (cachedItem != null) {
            ++this.deduplicated;
            return (T)cachedItem;
        }
        this.cache.put(item, item);
        return item;
    }

    public synchronized void clearCache() {
        this.attemptedInsertions = 0;
        this.deduplicated = 0;
        this.cache.invalidateAll();
    }

    public synchronized String toString() {
        return String.format("DedupInfo(%d/%d de-duplicated, %d pooled)", this.deduplicated, this.attemptedInsertions, this.cache.size());
    }
}

