/*
 * Decompiled with CFR 0.152.
 */
package com.mr_toad.palladium.common.entity.path;

import com.mr_toad.lib.mtjava.util.func.SelfFunction;
import com.mr_toad.palladium.api.GoalMapperProvider;
import com.mr_toad.palladium.common.entity.ai.goal.NearestAttackableTargetFastGoal;
import com.mr_toad.palladium.core.Palladium;
import com.mr_toad.palladium.core.mixin.accessor.NearestAttackTargetGoalAccessor;
import com.mr_toad.palladium.core.mixin.accessor.TargetGoalAccessor;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.TamableAnimal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.ai.goal.target.NonTameRandomTargetGoal;

public class TargetGoalMapperProvider
implements GoalMapperProvider {
    @Override
    public boolean canRun() {
        return (Boolean)Palladium.CONFIG.lightweightWolfAndCatAttackAi.get();
    }

    @Override
    public void run(Mob entity, ResourceLocation location) {
        this.replaceAttackableAll(entity);
        switch (location.m_135815_()) {
            case "cat": 
            case "wolf": {
                this.replaceTamed(entity);
                break;
            }
        }
    }

    private void replaceAttackableAll(Mob entity) {
        this.tryAndReplaceAllTasks(entity, entity.f_21346_, NearestAttackableTargetGoal.class, (SelfFunction<Goal>)((SelfFunction)goal -> {
            try {
                TargetGoalAccessor targetGoalAccessor = (TargetGoalAccessor)goal;
                NearestAttackTargetGoalAccessor nearestAttackTargetGoalAccessor = (NearestAttackTargetGoalAccessor)goal;
                return new NearestAttackableTargetFastGoal(targetGoalAccessor.getMob(), nearestAttackTargetGoalAccessor.getTarget(), targetGoalAccessor.isMustSee(), targetGoalAccessor.isMustReach(), nearestAttackTargetGoalAccessor.getTargetingConditions());
            }
            catch (Exception e) {
                return null;
            }
        }));
    }

    private void replaceTamed(Mob entity) {
        if (!(entity instanceof TamableAnimal)) {
            return;
        }
        this.tryAndReplaceAllTasks(entity, entity.f_21346_, NonTameRandomTargetGoal.class, (SelfFunction<Goal>)((SelfFunction)goal -> {
            try {
                final TargetGoalAccessor targetGoalAccessor = (TargetGoalAccessor)goal;
                NearestAttackTargetGoalAccessor nearestAttackTargetGoalAccessor = (NearestAttackTargetGoalAccessor)goal;
                return new NearestAttackableTargetFastGoal(targetGoalAccessor.getMob(), nearestAttackTargetGoalAccessor.getTarget(), targetGoalAccessor.isMustSee(), targetGoalAccessor.isMustReach(), nearestAttackTargetGoalAccessor.getTargetingConditions()){
                    private TamableAnimal tamableMob;

                    public Goal build() throws IllegalArgumentException {
                        this.tamableMob = (TamableAnimal)targetGoalAccessor.getMob();
                        return this;
                    }

                    @Override
                    public boolean m_8036_() {
                        return !this.tamableMob.m_27593_() && super.m_8036_();
                    }

                    public boolean m_8045_() {
                        return this.targetConditions != null ? this.targetConditions.m_26885_((LivingEntity)this.f_26135_, this.target) : super.m_8045_();
                    }
                }.build();
            }
            catch (Exception e) {
                return null;
            }
        }));
    }
}

