/*
 * Decompiled with CFR 0.152.
 */
package com.mr_toad.palladium.common.entity.processor;

import com.google.common.collect.Maps;
import com.mr_toad.palladium.common.entity.processor.EntityAiMappingProcessor;
import java.util.Map;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.ApiStatus;

@ApiStatus.Internal
public class EntityAiMappingProcessors {
    public static final Map<String, EntityAiMappingProcessor> PROCESSORS = Maps.newConcurrentMap();

    public static void init() {
        PROCESSORS.put("minecraft", EntityAiMappingProcessor.VANILLA);
    }

    public static void process(Level level, Entity entity) {
        if (!level.m_5776_() && entity instanceof Mob) {
            Mob mob = (Mob)entity;
            ResourceLocation id = EntityType.m_20613_((EntityType)entity.m_6095_());
            String namespace = id.m_135827_();
            EntityAiMappingProcessor modProcess = PROCESSORS.get(namespace);
            if (modProcess != null && modProcess.canUse()) {
                modProcess.process(mob, id);
            }
        }
    }
}

