/*
 * Decompiled with CFR 0.152.
 */
package com.mr_toad.palladium.common.util;

import it.unimi.dsi.fastutil.longs.LongCollection;
import it.unimi.dsi.fastutil.longs.LongIterator;
import it.unimi.dsi.fastutil.longs.LongOpenHashSet;
import java.util.BitSet;
import org.jetbrains.annotations.NotNull;

public final class FastBitSet
extends BitSet {
    private final LongOpenHashSet bitSet;

    public FastBitSet(int nbits) {
        super(nbits);
        this.bitSet = new LongOpenHashSet(nbits);
    }

    public FastBitSet() {
        this.bitSet = new LongOpenHashSet();
    }

    public FastBitSet(long[] longs) {
        this();
        for (int i = 0; i < longs.length * 64; ++i) {
            if ((longs[i / 64] & 1L << i % 64) == 0L) continue;
            this.set(i);
        }
    }

    public FastBitSet(BitSet bitSet) {
        this();
        int i = bitSet.nextSetBit(0);
        while (i >= 0) {
            this.set(i);
            i = bitSet.nextSetBit(i + 1);
        }
    }

    @Override
    public void set(int index) {
        this.bitSet.add((long)index);
        super.set(index);
    }

    @Override
    public void clear(int index) {
        this.bitSet.remove((long)index);
        super.clear(index);
    }

    @Override
    public boolean get(int index) {
        return this.bitSet.contains((long)index);
    }

    @Override
    public int cardinality() {
        return this.bitSet.size();
    }

    @Override
    public void or(@NotNull BitSet other) {
        if (other instanceof FastBitSet) {
            FastBitSet lbs = (FastBitSet)other;
            this.bitSet.addAll((LongCollection)lbs.bitSet);
        }
        super.or(other);
    }

    @Override
    public void and(@NotNull BitSet other) {
        if (other instanceof FastBitSet) {
            FastBitSet lbs = (FastBitSet)other;
            this.bitSet.retainAll((LongCollection)lbs.bitSet);
        }
        super.and(other);
    }

    @Override
    public void andNot(@NotNull BitSet other) {
        if (other instanceof FastBitSet) {
            FastBitSet lbs = (FastBitSet)other;
            this.bitSet.removeAll((LongCollection)lbs.bitSet);
        }
        super.andNot(other);
    }

    @Override
    public void xor(@NotNull BitSet other) {
        if (other instanceof FastBitSet) {
            FastBitSet lbs = (FastBitSet)other;
            LongIterator longIterator = lbs.bitSet.iterator();
            while (longIterator.hasNext()) {
                long element = (Long)longIterator.next();
                if (this.bitSet.contains(element)) {
                    this.bitSet.remove(element);
                    super.clear((int)element);
                    continue;
                }
                this.bitSet.add(element);
                super.set((int)element);
            }
        }
    }

    @Override
    public long[] toLongArray() {
        return this.bitSet.toLongArray();
    }
}

