/*
 * Decompiled with CFR 0.152.
 */
package com.mr_toad.palladium.core;

import com.mr_toad.lib.api.config.ToadConfig;
import com.mr_toad.lib.api.config.ToadConfigs;
import com.mr_toad.palladium.common.Deduplicator;
import com.mr_toad.palladium.common.entity.processor.EntityAiMappingProcessors;
import com.mr_toad.palladium.core.config.PalladiumConfig;
import com.mr_toad.palladium.core.config.ResourceLocationDeduplication;
import java.lang.ref.Cleaner;
import java.util.concurrent.TimeUnit;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.resources.ResourceLocation;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.fml.DistExecutor;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Mod(value="mr_toad_palladium")
public class Palladium {
    public static final String MODID = "mr_toad_palladium";
    public static final Logger LOGGER = LoggerFactory.getLogger((String)"Palladium");
    public static final Deduplicator<String> NAMESPACES = new Deduplicator(30, 20, TimeUnit.MINUTES);
    public static final Deduplicator<String> PATH = new Deduplicator(100, 10, TimeUnit.MINUTES);
    public static final Deduplicator<String> PROPERTIES = new Deduplicator(50, 5, TimeUnit.MINUTES);
    public static final Deduplicator<BakedQuad> QUADS = new Deduplicator(120, 2, TimeUnit.MINUTES);
    public static final PalladiumConfig CONFIG = new PalladiumConfig();
    public static final Cleaner CLEANER = Cleaner.create();

    public Palladium() {
        IEventBus bus = FMLJavaModLoadingContext.get().getModEventBus();
        bus.addListener(this::onCommon);
        DistExecutor.unsafeRunWhenOn((Dist)Dist.CLIENT, () -> () -> bus.addListener(this::clientSetupEvent));
        MinecraftForge.EVENT_BUS.register((Object)this);
    }

    public static boolean isResourceDedup(ResourceLocationDeduplication deduplication) {
        if (Palladium.CONFIG.resourceLocationDeduplication.get() == ResourceLocationDeduplication.ALL) {
            return true;
        }
        if (Palladium.CONFIG.resourceLocationDeduplication.get() == ResourceLocationDeduplication.NONE) {
            return false;
        }
        return Palladium.CONFIG.resourceLocationDeduplication.get() == deduplication;
    }

    private void onCommon(FMLCommonSetupEvent event) {
        event.enqueueWork(EntityAiMappingProcessors::init);
    }

    private void clientSetupEvent(FMLClientSetupEvent event) {
        event.enqueueWork(() -> ToadConfigs.create((String)MODID, (ToadConfig)CONFIG));
    }

    public static boolean isFabulous() {
        return Minecraft.m_91085_();
    }

    public static ResourceLocation makeRl(String path) {
        return new ResourceLocation(MODID, path);
    }
}

