/*
 * Decompiled with CFR 0.152.
 */
package com.mr_toad.palladium.core.mixin;

import com.mr_toad.palladium.core.Palladium;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.util.LinearCongruentialGenerator;
import net.minecraft.util.Mth;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.biome.BiomeManager;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={BiomeManager.class})
public abstract class BiomeManagerMixin {
    @Shadow
    @Final
    private long f_47863_;
    @Shadow
    @Final
    private BiomeManager.NoiseBiomeSource f_47862_;
    @Unique
    private static final double palladium$maxOffset = 0.4500000001;

    @Shadow
    private static double m_186689_(long l) {
        return 0.0;
    }

    @Inject(method={"getBiome"}, at={@At(value="HEAD")}, cancellable=true)
    public void optimizedGetBiome(BlockPos pos, CallbackInfoReturnable<Holder<Biome>> cir) {
        int biomeX;
        if (!((Boolean)Palladium.CONFIG.biomeFix.get()).booleanValue()) {
            cir.setReturnValue((Object)((Holder)cir.getReturnValue()));
        }
        int xMinus2 = pos.m_123341_() - 2;
        int yMinus2 = pos.m_123342_() - 2;
        int zMinus2 = pos.m_123343_() - 2;
        int x = xMinus2 >> 2;
        int y = yMinus2 >> 2;
        int z = zMinus2 >> 2;
        double quartX = (double)(xMinus2 & 3) / 4.0;
        double quartY = (double)(yMinus2 & 3) / 4.0;
        double quartZ = (double)(zMinus2 & 3) / 4.0;
        int smallestX = 0;
        double smallestDist = Double.POSITIVE_INFINITY;
        for (biomeX = 0; biomeX < 8; ++biomeX) {
            double offsetZ;
            double biomeDist;
            boolean everyOtherQuad = (biomeX & 4) == 0;
            boolean everyOtherPair = (biomeX & 2) == 0;
            boolean everyOther = (biomeX & 1) == 0;
            double quartXX = everyOtherQuad ? quartX : quartX - 1.0;
            double quartYY = everyOtherPair ? quartY : quartY - 1.0;
            double quartZZ = everyOther ? quartZ : quartZ - 1.0;
            double maxQuartYY = 0.0;
            double maxQuartZZ = 0.0;
            if (biomeX != 0) {
                maxQuartYY = Mth.m_144952_((double)Math.max(quartYY + 0.4500000001, Math.abs(quartYY - 0.4500000001)));
                maxQuartZZ = Mth.m_144952_((double)Math.max(quartZZ + 0.4500000001, Math.abs(quartZZ - 0.4500000001)));
                double maxQuartXX = Mth.m_144952_((double)Math.max(quartXX + 0.4500000001, Math.abs(quartXX - 0.4500000001)));
                if (smallestDist < maxQuartXX + maxQuartYY + maxQuartZZ) continue;
            }
            int xx = everyOtherQuad ? x : x + 1;
            int yy = everyOtherPair ? y : y + 1;
            int zz = everyOther ? z : z + 1;
            long seed = LinearCongruentialGenerator.m_13972_((long)this.f_47863_, (long)xx);
            seed = LinearCongruentialGenerator.m_13972_((long)seed, (long)yy);
            seed = LinearCongruentialGenerator.m_13972_((long)seed, (long)zz);
            seed = LinearCongruentialGenerator.m_13972_((long)seed, (long)xx);
            seed = LinearCongruentialGenerator.m_13972_((long)seed, (long)yy);
            seed = LinearCongruentialGenerator.m_13972_((long)seed, (long)zz);
            double offsetX = BiomeManagerMixin.m_186689_(seed);
            double sqrX = Mth.m_144952_((double)(quartXX + offsetX));
            if (biomeX != 0 && smallestDist < sqrX + maxQuartYY + maxQuartZZ) continue;
            seed = LinearCongruentialGenerator.m_13972_((long)seed, (long)this.f_47863_);
            double offsetY = BiomeManagerMixin.m_186689_(seed);
            double sqrY = Mth.m_144952_((double)(quartYY + offsetY));
            if (biomeX != 0 && smallestDist < sqrX + sqrY + maxQuartZZ || !(smallestDist > (biomeDist = sqrX + sqrY + Mth.m_144952_((double)(quartZZ + (offsetZ = BiomeManagerMixin.m_186689_(seed = LinearCongruentialGenerator.m_13972_((long)seed, (long)this.f_47863_)))))))) continue;
            smallestX = biomeX;
            smallestDist = biomeDist;
        }
        biomeX = (smallestX & 4) == 0 ? x : x + 1;
        int biomeY = (smallestX & 2) == 0 ? y : y + 1;
        int biomeZ = (smallestX & 1) == 0 ? z : z + 1;
        cir.setReturnValue((Object)this.f_47862_.m_203495_(biomeX, biomeY, biomeZ));
    }
}

