/*
 * Decompiled with CFR 0.152.
 */
package com.mr_toad.palladium.core.mixin;

import com.google.common.base.Supplier;
import com.google.common.base.Suppliers;
import com.mr_toad.palladium.common.util.ImmutableHashMap;
import com.mr_toad.palladium.core.Palladium;
import it.unimi.dsi.fastutil.longs.LongSet;
import it.unimi.dsi.fastutil.longs.LongSets;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.objects.Object2ReferenceOpenHashMap;
import it.unimi.dsi.fastutil.objects.ObjectOpenHashSet;
import it.unimi.dsi.fastutil.objects.ObjectSet;
import it.unimi.dsi.fastutil.objects.ObjectSets;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Registry;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.LevelHeightAccessor;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.chunk.ChunkAccess;
import net.minecraft.world.level.chunk.LevelChunkSection;
import net.minecraft.world.level.chunk.UpgradeData;
import net.minecraft.world.level.levelgen.blending.BlendingData;
import net.minecraft.world.level.levelgen.structure.Structure;
import net.minecraft.world.level.levelgen.structure.StructureStart;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Mutable;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={ChunkAccess.class})
public abstract class ChunkAccessMixin {
    @Unique
    private static final Supplier<LongSet> EMPTY_REF = Suppliers.memoize(LongSets::emptySet);
    @Mutable
    @Shadow
    @Final
    private Map<Structure, LongSet> f_187618_;
    @Mutable
    @Shadow
    @Final
    private Map<Structure, StructureStart> f_187617_;
    @Mutable
    @Shadow
    @Final
    protected Map<BlockPos, CompoundTag> f_187609_;
    @Mutable
    @Shadow
    @Final
    protected Map<BlockPos, BlockEntity> f_187610_;
    @Unique
    private final AtomicBoolean palladium$lightCorrect = new AtomicBoolean(false);
    @Unique
    private final AtomicBoolean palladium$isUnsaved = new AtomicBoolean(false);

    @Inject(method={"<init>"}, at={@At(value="TAIL")})
    public void mapReplaceInit(ChunkPos pos, UpgradeData data, LevelHeightAccessor accessor, Registry<Biome> biome, long time, LevelChunkSection[] sections, BlendingData blendingData, CallbackInfo ci) {
        if (((Boolean)Palladium.CONFIG.chunkOptimizations.get()).booleanValue()) {
            this.f_187617_ = new Object2ObjectOpenHashMap();
            this.f_187618_ = new Object2ReferenceOpenHashMap();
            this.f_187609_ = new Object2ObjectOpenHashMap();
            this.f_187610_ = new Object2ObjectOpenHashMap();
        }
    }

    @Inject(method={"getAllReferences"}, at={@At(value="RETURN")}, cancellable=true)
    public void getImmutableRefs(CallbackInfoReturnable<Map<Structure, LongSet>> cir) {
        if (((Boolean)Palladium.CONFIG.chunkOptimizations.get()).booleanValue()) {
            cir.setReturnValue(new ImmutableHashMap<Structure, LongSet>(this.f_187618_));
        }
    }

    @Inject(method={"getAllStarts"}, at={@At(value="RETURN")}, cancellable=true)
    public void getImmutableStarts(CallbackInfoReturnable<Map<Structure, StructureStart>> cir) {
        if (((Boolean)Palladium.CONFIG.chunkOptimizations.get()).booleanValue()) {
            cir.setReturnValue(new ImmutableHashMap<Structure, StructureStart>(this.f_187617_));
        }
    }

    @Inject(method={"getBlockEntitiesPos"}, at={@At(value="HEAD")}, cancellable=true)
    public void getImmutableBEPos(CallbackInfoReturnable<Set<BlockPos>> cir) {
        if (((Boolean)Palladium.CONFIG.chunkOptimizations.get()).booleanValue()) {
            ObjectOpenHashSet set = new ObjectOpenHashSet(this.f_187609_.keySet());
            set.addAll(this.f_187610_.keySet());
            cir.setReturnValue((Object)ObjectSets.unmodifiable((ObjectSet)set));
        }
    }

    @Inject(method={"setStartForStructure"}, at={@At(value="HEAD")}, cancellable=true)
    public void addOrGetStructureStart(Structure structure, StructureStart start, CallbackInfo ci) {
        if (((Boolean)Palladium.CONFIG.chunkOptimizations.get()).booleanValue()) {
            this.f_187617_.computeIfAbsent(structure, s -> start);
            this.palladium$isUnsaved.set(true);
            ci.cancel();
        }
    }

    @Inject(method={"setAllStarts"}, at={@At(value="TAIL")})
    public void atomicUnsavedSetAllStarts(Map<Structure, StructureStart> p_62090_, CallbackInfo ci) {
        if (((Boolean)Palladium.CONFIG.chunkOptimizations.get()).booleanValue()) {
            this.palladium$isUnsaved.set(true);
        }
    }

    @Inject(method={"getReferencesForStructure"}, at={@At(value="HEAD")}, cancellable=true)
    public void getUnmodifiableRefsForStructure(Structure structure, CallbackInfoReturnable<LongSet> cir) {
        if (((Boolean)Palladium.CONFIG.chunkOptimizations.get()).booleanValue()) {
            cir.setReturnValue((Object)this.f_187618_.getOrDefault(structure, (LongSet)EMPTY_REF.get()));
        }
    }

    @Inject(method={"setUnsaved"}, at={@At(value="HEAD")})
    public void atomicSetUnsaved(boolean value, CallbackInfo ci) {
        if (((Boolean)Palladium.CONFIG.chunkOptimizations.get()).booleanValue()) {
            this.palladium$isUnsaved.set(value);
        }
    }

    @Inject(method={"isUnsaved"}, at={@At(value="RETURN")}, cancellable=true)
    public void atomicUnsaved(CallbackInfoReturnable<Boolean> cir) {
        if (((Boolean)Palladium.CONFIG.chunkOptimizations.get()).booleanValue()) {
            cir.setReturnValue((Object)this.palladium$isUnsaved.get());
        }
    }

    @Inject(method={"setLightCorrect"}, at={@At(value="HEAD")}, cancellable=true)
    public void setLightCorrect(boolean value, CallbackInfo ci) {
        if (((Boolean)Palladium.CONFIG.chunkOptimizations.get()).booleanValue()) {
            this.palladium$lightCorrect.set(value);
            this.palladium$isUnsaved.set(true);
            ci.cancel();
        }
    }

    @Inject(method={"isLightCorrect"}, at={@At(value="RETURN")}, cancellable=true)
    public void atomicLightCorrect(CallbackInfoReturnable<Boolean> cir) {
        if (((Boolean)Palladium.CONFIG.chunkOptimizations.get()).booleanValue()) {
            cir.setReturnValue((Object)this.palladium$lightCorrect.get());
        }
    }
}

