/*
 * Decompiled with CFR 0.152.
 */
package com.mr_toad.palladium.core.mixin;

import com.mr_toad.palladium.core.Palladium;
import java.util.function.Supplier;
import net.minecraft.core.Direction;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

public abstract class ComposterBlockMixin {
    private static final Supplier<int[]> ZERO = () -> new int[0];
    private static final Supplier<int[]> ONE = () -> new int[]{0};

    @Mixin(targets={"net.minecraft.world.level.block.ComposterBlock.OutputContainer"})
    public static class OutputContainerMixin {
        @Inject(method={"getSlotsForFace"}, at={@At(value="RETURN")}, cancellable=true)
        public void getAtDown(Direction direction, CallbackInfoReturnable<int[]> cir) {
            if (((Boolean)Palladium.CONFIG.enableComposterFix.get()).booleanValue()) {
                if (direction == Direction.DOWN) {
                    cir.setReturnValue((Object)ONE.get());
                } else {
                    cir.setReturnValue((Object)ZERO.get());
                }
            }
        }
    }

    @Mixin(targets={"net.minecraft.world.level.block.ComposterBlock.InputContainer"})
    public static class InputContainerMixin {
        @Inject(method={"getSlotsForFace"}, at={@At(value="RETURN")}, cancellable=true)
        public void getAtUp(Direction direction, CallbackInfoReturnable<int[]> cir) {
            if (((Boolean)Palladium.CONFIG.enableComposterFix.get()).booleanValue()) {
                if (direction == Direction.UP) {
                    cir.setReturnValue((Object)ONE.get());
                } else {
                    cir.setReturnValue((Object)ZERO.get());
                }
            }
        }
    }

    @Mixin(targets={"net.minecraft.world.level.block.ComposterBlock.EmptyContainer"})
    public static class EmptyContainerMixin {
        @Inject(method={"getSlotsForFace"}, at={@At(value="RETURN")}, cancellable=true)
        public void getEmptySlots(Direction direction, CallbackInfoReturnable<int[]> cir) {
            if (((Boolean)Palladium.CONFIG.enableComposterFix.get()).booleanValue()) {
                cir.setReturnValue((Object)ZERO.get());
            }
        }
    }
}

