/*
 * Decompiled with CFR 0.152.
 */
package com.mr_toad.palladium.core.mixin;

import com.google.common.base.Objects;
import com.google.common.collect.Iterables;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.mojang.authlib.GameProfile;
import com.mojang.authlib.minecraft.MinecraftProfileTexture;
import com.mojang.authlib.properties.Property;
import com.mojang.authlib.yggdrasil.response.MinecraftTexturesPayload;
import com.mojang.util.UUIDTypeAdapter;
import com.mr_toad.palladium.core.Palladium;
import it.unimi.dsi.fastutil.objects.Object2ObjectMap;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.objects.ReferenceOpenHashSet;
import it.unimi.dsi.fastutil.objects.ReferenceSets;
import java.nio.charset.StandardCharsets;
import java.util.Collection;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.nbt.Tag;
import org.apache.commons.codec.binary.Base64;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Mutable;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.Redirect;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={CompoundTag.class})
public abstract class CompoundTagMixin {
    @Unique
    private static final Gson palladium$GSON = new GsonBuilder().registerTypeAdapter(UUID.class, (Object)new UUIDTypeAdapter()).create();
    @Mutable
    @Shadow
    @Final
    private Map<String, Tag> f_128329_;

    @Inject(method={"<init>(Ljava/util/Map;)V"}, at={@At(value="RETURN")})
    private void straightElementMap(Map<String, Tag> tags, CallbackInfo ci) {
        if (((Boolean)Palladium.CONFIG.nbtOptimizations.get()).booleanValue()) {
            this.f_128329_ = tags instanceof Object2ObjectMap ? tags : new Object2ObjectOpenHashMap((Map)tags);
        }
    }

    @Inject(method={"getAllKeys"}, at={@At(value="RETURN")}, cancellable=true)
    public void getAllKeysAsReference(CallbackInfoReturnable<Set<String>> cir) {
        if (((Boolean)Palladium.CONFIG.nbtOptimizations.get()).booleanValue()) {
            Set superr = (Set)cir.getReturnValue();
            cir.setReturnValue(superr.isEmpty() ? ReferenceSets.emptySet() : new ReferenceOpenHashSet((Collection)superr));
        }
    }

    @Redirect(method={"equals"}, at=@At(value="INVOKE", target="java/util/Objects.equals(Ljava/lang/Object;Ljava/lang/Object;)Z"))
    private boolean skullEquals(Object object1, Object object2) {
        if (Objects.equal((Object)object1, (Object)object2)) {
            return true;
        }
        Tag skullOwner1 = (Tag)((Map)object1).get("SkullOwner");
        Tag skullOwner2 = (Tag)((Map)object2).get("SkullOwner");
        if (!(skullOwner1 instanceof CompoundTag) || !(skullOwner2 instanceof CompoundTag)) {
            return false;
        }
        GameProfile profile1 = NbtUtils.m_129228_((CompoundTag)((CompoundTag)skullOwner1));
        GameProfile profile2 = NbtUtils.m_129228_((CompoundTag)((CompoundTag)skullOwner2));
        if (profile1 == null || !profile1.equals((Object)profile2)) {
            return false;
        }
        Optional<MinecraftProfileTexture> texture1 = this.palladium$profile(profile1);
        Optional<MinecraftProfileTexture> texture2 = this.palladium$profile(profile2);
        return texture1.isPresent() && texture2.isPresent() && texture1.get().getUrl().equals(texture2.get().getUrl());
    }

    @Unique
    private Optional<MinecraftProfileTexture> palladium$profile(GameProfile profile) {
        return this.palladium$getTexturesPayload(profile).map(p -> (MinecraftProfileTexture)p.getTextures().get(MinecraftProfileTexture.Type.SKIN));
    }

    @Unique
    private Optional<MinecraftTexturesPayload> palladium$getTexturesPayload(GameProfile profile) {
        Property textureProperty = (Property)Iterables.getFirst((Iterable)profile.getProperties().get((Object)"textures"), null);
        if (textureProperty == null) {
            return Optional.empty();
        }
        return Optional.of((MinecraftTexturesPayload)palladium$GSON.fromJson(new String(Base64.decodeBase64((String)textureProperty.getValue()), StandardCharsets.UTF_8), MinecraftTexturesPayload.class));
    }
}

