/*
 * Decompiled with CFR 0.152.
 */
package com.mr_toad.palladium.core.mixin;

import com.mr_toad.palladium.core.Palladium;
import java.util.List;
import java.util.Map;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.resources.model.SimpleBakedModel;
import net.minecraft.core.Direction;
import net.minecraftforge.fml.ModList;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={SimpleBakedModel.Builder.class})
public abstract class SimpleBakedModelBuilderMixin {
    @Shadow
    @Final
    private Map<Direction, List<BakedQuad>> f_119509_;
    @Shadow
    @Final
    private List<BakedQuad> f_119508_;

    @Inject(method={"addCulledFace"}, at={@At(value="HEAD")})
    private void dedupCulled(Direction direction, BakedQuad quad, CallbackInfoReturnable<SimpleBakedModel.Builder> cir) {
        if (this.isAllowed()) {
            this.f_119509_.get(direction).add(Palladium.QUADS.deduplicate(quad));
        }
    }

    @Inject(method={"addUnculledFace"}, at={@At(value="HEAD")})
    private void dedupUnculled(BakedQuad quad, CallbackInfoReturnable<SimpleBakedModel.Builder> cir) {
        if (this.isAllowed()) {
            this.f_119508_.add(Palladium.QUADS.deduplicate(quad));
        }
    }

    private boolean isAllowed() {
        return !ModList.get().isLoaded("ferritecore") && (Boolean)Palladium.CONFIG.enableQuadsDedup.get() != false;
    }
}

