/*
 * Decompiled with CFR 0.152.
 */
package com.mr_toad.palladium.client.shader;

import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mr_toad.lib.core.ToadLib;
import com.mr_toad.palladium.client.shader.gl.GlUniform;
import com.mr_toad.palladium.core.Palladium;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import org.lwjgl.opengl.GL11;
import org.lwjgl.opengl.GL20;

@OnlyIn(value=Dist.CLIENT)
public class ShaderCacheLoader {
    private static final Int2ObjectMap<GlUniform> UNIFORM_CACHE = new Int2ObjectOpenHashMap();
    private static final Cache<Integer, Integer> ATTRIBUTE_CACHE = CacheBuilder.newBuilder().maximumSize(500L).expireAfterWrite(6L, TimeUnit.MINUTES).build();
    private static final Cache<Integer, Integer> MIPMAP_CACHE = CacheBuilder.newBuilder().maximumSize(70L).expireAfterWrite(1L, TimeUnit.MINUTES).build();

    public static void reload(String log) {
        RenderSystem.assertOnRenderThread();
        if (!((Boolean)Palladium.CONFIG.enableShaderUniformCaching.get()).booleanValue()) {
            if (!UNIFORM_CACHE.isEmpty()) {
                UNIFORM_CACHE.clear();
            }
        } else {
            Palladium.LOGGER.info("Uniform cache reload({})", (Object)log);
            UNIFORM_CACHE.clear();
        }
        ShaderCacheLoader.reloading((Boolean)Palladium.CONFIG.enableShaderAttributeCaching.get(), ATTRIBUTE_CACHE, "Vertex attribute cache reload(" + log + ")");
        ShaderCacheLoader.reloading((Boolean)Palladium.CONFIG.enableMipmapCaching.get(), MIPMAP_CACHE, "Mipmap cache reload(" + log + ")");
    }

    public static int uniform(int id, CharSequence charSequence) {
        RenderSystem.assertOnRenderThread();
        return ((GlUniform)UNIFORM_CACHE.computeIfAbsent(id, GlUniform::new)).uniform(charSequence);
    }

    public static int attribute(int id, CharSequence charSequence) {
        RenderSystem.assertOnRenderThread();
        int attrib = GL20.glGetAttribLocation((int)id, (CharSequence)charSequence);
        try {
            return (Integer)ATTRIBUTE_CACHE.get((Object)id, () -> attrib);
        }
        catch (ExecutionException e) {
            ToadLib.LOGGER.error("Vertex attribute cache error.", (Throwable)e);
            return attrib;
        }
    }

    public static int mipmap(int id, int level, int name) {
        RenderSystem.assertOnRenderThread();
        int texLvl = GL11.glGetTexLevelParameteri((int)id, (int)level, (int)name);
        try {
            return (Integer)MIPMAP_CACHE.get((Object)id, () -> texLvl);
        }
        catch (ExecutionException e) {
            ToadLib.LOGGER.error("Mipmap cache error.", (Throwable)e);
            return texLvl;
        }
    }

    private static void reloading(boolean cfgValue, Cache<?, ?> toReload, String log) {
        if (!cfgValue) {
            if (toReload.size() != 0L) {
                toReload.invalidateAll();
            }
        } else {
            Palladium.LOGGER.info(log);
            toReload.invalidateAll();
        }
    }
}

