/*
 * Decompiled with CFR 0.152.
 */
package com.mr_toad.palladium.core;

import com.mr_toad.lib.api.config.ToadConfig;
import com.mr_toad.lib.api.config.ToadConfigs;
import com.mr_toad.palladium.common.Deduplicator;
import com.mr_toad.palladium.core.config.PalladiumConfig;
import com.mr_toad.palladium.core.config.ResourceLocationDeduplication;
import java.util.concurrent.TimeUnit;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.resources.ResourceLocation;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.fml.common.Mod;
import net.neoforged.fml.event.lifecycle.FMLClientSetupEvent;
import net.neoforged.fml.loading.FMLEnvironment;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Mod(value="mr_toad_palladium")
public class Palladium {
    public static final String MODID = "mr_toad_palladium";
    public static final Logger LOGGER = LoggerFactory.getLogger((String)"Palladium");
    public static final Deduplicator<String> NAMESPACES = new Deduplicator(25, TimeUnit.MINUTES);
    public static final Deduplicator<String> PATH = new Deduplicator(25, TimeUnit.MINUTES);
    public static final Deduplicator<String> PROPERTIES = new Deduplicator(30, TimeUnit.MINUTES);
    public static final Deduplicator<BakedQuad> QUADS = new Deduplicator(2, 120, TimeUnit.MINUTES);
    public static final PalladiumConfig CONFIG = new PalladiumConfig();
    public static final int[] ZERO = new int[0];
    public static final int[] ONE = new int[]{0};

    public Palladium(IEventBus bus) {
        if (FMLEnvironment.dist.isClient()) {
            bus.addListener(this::clientSetupEvent);
        }
    }

    public static boolean isResourceDedup(ResourceLocationDeduplication deduplication) {
        if (Palladium.CONFIG.resourceLocationDeduplication.get() == ResourceLocationDeduplication.ALL) {
            return true;
        }
        if (Palladium.CONFIG.resourceLocationDeduplication.get() == ResourceLocationDeduplication.NONE) {
            return false;
        }
        return Palladium.CONFIG.resourceLocationDeduplication.get() == deduplication;
    }

    private void clientSetupEvent(FMLClientSetupEvent event) {
        event.enqueueWork(() -> ToadConfigs.create((String)MODID, (ToadConfig)CONFIG));
    }

    public static boolean isFabulous() {
        return Minecraft.useShaderTransparency();
    }

    public static ResourceLocation makeRl(String path) {
        return ResourceLocation.fromNamespaceAndPath((String)MODID, (String)path);
    }
}

