/*
 * Decompiled with CFR 0.152.
 */
package com.mr_toad.palladium.core.mixin;

import com.mr_toad.palladium.core.Palladium;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.util.LinearCongruentialGenerator;
import net.minecraft.util.Mth;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.biome.BiomeManager;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={BiomeManager.class})
public abstract class BiomeManagerMixin {
    @Shadow
    @Final
    private long biomeZoomSeed;
    @Shadow
    @Final
    private BiomeManager.NoiseBiomeSource noiseBiomeSource;
    @Unique
    private static final double palladium$maxOffset = 0.4500000001;

    @Shadow
    private static double getFiddle(long l) {
        return 0.0;
    }

    @Inject(method={"getBiome"}, at={@At(value="HEAD")}, cancellable=true)
    public void optimizedGetBiome(BlockPos pos, CallbackInfoReturnable<Holder<Biome>> cir) {
        int biomeX;
        if (!((Boolean)Palladium.CONFIG.biomeFix.get()).booleanValue()) {
            cir.setReturnValue((Object)((Holder)cir.getReturnValue()));
        }
        int xMinus2 = pos.getX() - 2;
        int yMinus2 = pos.getY() - 2;
        int zMinus2 = pos.getZ() - 2;
        int x = xMinus2 >> 2;
        int y = yMinus2 >> 2;
        int z = zMinus2 >> 2;
        double quartX = (double)(xMinus2 & 3) / 4.0;
        double quartY = (double)(yMinus2 & 3) / 4.0;
        double quartZ = (double)(zMinus2 & 3) / 4.0;
        int smallestX = 0;
        double smallestDist = Double.POSITIVE_INFINITY;
        for (biomeX = 0; biomeX < 8; ++biomeX) {
            double offsetZ;
            double biomeDist;
            boolean everyOtherQuad = (biomeX & 4) == 0;
            boolean everyOtherPair = (biomeX & 2) == 0;
            boolean everyOther = (biomeX & 1) == 0;
            double quartXX = everyOtherQuad ? quartX : quartX - 1.0;
            double quartYY = everyOtherPair ? quartY : quartY - 1.0;
            double quartZZ = everyOther ? quartZ : quartZ - 1.0;
            double maxQuartYY = 0.0;
            double maxQuartZZ = 0.0;
            if (biomeX != 0) {
                maxQuartYY = Mth.square((double)Math.max(quartYY + 0.4500000001, Math.abs(quartYY - 0.4500000001)));
                maxQuartZZ = Mth.square((double)Math.max(quartZZ + 0.4500000001, Math.abs(quartZZ - 0.4500000001)));
                double maxQuartXX = Mth.square((double)Math.max(quartXX + 0.4500000001, Math.abs(quartXX - 0.4500000001)));
                if (smallestDist < maxQuartXX + maxQuartYY + maxQuartZZ) continue;
            }
            int xx = everyOtherQuad ? x : x + 1;
            int yy = everyOtherPair ? y : y + 1;
            int zz = everyOther ? z : z + 1;
            long seed = LinearCongruentialGenerator.next((long)this.biomeZoomSeed, (long)xx);
            seed = LinearCongruentialGenerator.next((long)seed, (long)yy);
            seed = LinearCongruentialGenerator.next((long)seed, (long)zz);
            seed = LinearCongruentialGenerator.next((long)seed, (long)xx);
            seed = LinearCongruentialGenerator.next((long)seed, (long)yy);
            seed = LinearCongruentialGenerator.next((long)seed, (long)zz);
            double offsetX = BiomeManagerMixin.getFiddle(seed);
            double sqrX = Mth.square((double)(quartXX + offsetX));
            if (biomeX != 0 && smallestDist < sqrX + maxQuartYY + maxQuartZZ) continue;
            seed = LinearCongruentialGenerator.next((long)seed, (long)this.biomeZoomSeed);
            double offsetY = BiomeManagerMixin.getFiddle(seed);
            double sqrY = Mth.square((double)(quartYY + offsetY));
            if (biomeX != 0 && smallestDist < sqrX + sqrY + maxQuartZZ || !(smallestDist > (biomeDist = sqrX + sqrY + Mth.square((double)(quartZZ + (offsetZ = BiomeManagerMixin.getFiddle(seed = LinearCongruentialGenerator.next((long)seed, (long)this.biomeZoomSeed)))))))) continue;
            smallestX = biomeX;
            smallestDist = biomeDist;
        }
        biomeX = (smallestX & 4) == 0 ? x : x + 1;
        int biomeY = (smallestX & 2) == 0 ? y : y + 1;
        int biomeZ = (smallestX & 1) == 0 ? z : z + 1;
        cir.setReturnValue((Object)this.noiseBiomeSource.getNoiseBiome(biomeX, biomeY, biomeZ));
    }
}

