/*
 * Decompiled with CFR 0.152.
 */
package com.mr_toad.palladium.core.mixin;

import com.google.common.base.Supplier;
import com.google.common.base.Suppliers;
import com.mr_toad.palladium.common.util.AtomicChunkAccess;
import com.mr_toad.palladium.common.util.ImmutableHashMap;
import com.mr_toad.palladium.core.Palladium;
import it.unimi.dsi.fastutil.longs.LongOpenHashSet;
import it.unimi.dsi.fastutil.longs.LongSet;
import it.unimi.dsi.fastutil.longs.LongSets;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.objects.Object2ReferenceOpenHashMap;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import net.minecraft.core.Registry;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.LevelHeightAccessor;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.chunk.ChunkAccess;
import net.minecraft.world.level.chunk.LevelChunkSection;
import net.minecraft.world.level.chunk.UpgradeData;
import net.minecraft.world.level.levelgen.blending.BlendingData;
import net.minecraft.world.level.levelgen.structure.Structure;
import net.minecraft.world.level.levelgen.structure.StructureStart;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Mutable;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={ChunkAccess.class})
public abstract class ChunkAccessMixin
implements AtomicChunkAccess {
    @Unique
    private static final Supplier<LongSet> EMPTY_REF = Suppliers.memoize(LongSets::emptySet);
    @Mutable
    @Shadow
    @Final
    private Map<Structure, LongSet> structuresRefences;
    @Mutable
    @Shadow
    @Final
    private Map<Structure, StructureStart> structureStarts;
    @Shadow
    protected volatile boolean unsaved;
    @Unique
    private final AtomicBoolean palladium$lightCorrect = new AtomicBoolean(false);
    @Unique
    private final AtomicBoolean palladium$isUnsaved = new AtomicBoolean(false);

    @Inject(method={"<init>"}, at={@At(value="TAIL")})
    public void mapReplaceInit(ChunkPos pos, UpgradeData data, LevelHeightAccessor accessor, Registry<Biome> biome, long time, LevelChunkSection[] sections, BlendingData blendingData, CallbackInfo ci) {
        if (((Boolean)Palladium.CONFIG.chunkOptimizations.get()).booleanValue()) {
            this.structureStarts = new Object2ObjectOpenHashMap();
            this.structuresRefences = new Object2ReferenceOpenHashMap();
        }
    }

    @Inject(method={"getAllReferences"}, at={@At(value="RETURN")}, cancellable=true)
    public void getImmutableRefs(CallbackInfoReturnable<Map<Structure, LongSet>> cir) {
        if (((Boolean)Palladium.CONFIG.chunkOptimizations.get()).booleanValue()) {
            cir.setReturnValue(new ImmutableHashMap<Structure, LongSet>(this.structuresRefences));
        }
    }

    @Inject(method={"getAllStarts"}, at={@At(value="RETURN")}, cancellable=true)
    public void getImmutableStarts(CallbackInfoReturnable<Map<Structure, StructureStart>> cir) {
        if (((Boolean)Palladium.CONFIG.chunkOptimizations.get()).booleanValue()) {
            cir.setReturnValue(new ImmutableHashMap<Structure, StructureStart>(this.structureStarts));
        }
    }

    @Inject(method={"setAllStarts"}, at={@At(value="HEAD")}, cancellable=true)
    public void setAllStrs(Map<Structure, StructureStart> map, CallbackInfo ci) {
        if (((Boolean)Palladium.CONFIG.chunkOptimizations.get()).booleanValue()) {
            this.structureStarts.clear();
            this.structureStarts.putAll(map);
            this.palladium$isUnsaved.set(true);
            ci.cancel();
        }
    }

    @Inject(method={"setAllReferences"}, at={@At(value="HEAD")}, cancellable=true)
    public void setAllRefs(Map<Structure, LongSet> map, CallbackInfo ci) {
        if (((Boolean)Palladium.CONFIG.chunkOptimizations.get()).booleanValue()) {
            this.structuresRefences.clear();
            this.structuresRefences.putAll(map);
            this.palladium$isUnsaved.set(true);
            ci.cancel();
        }
    }

    @Inject(method={"setStartForStructure"}, at={@At(value="HEAD")}, cancellable=true)
    public void addOrGetStructureStart(Structure structure, StructureStart start, CallbackInfo ci) {
        if (((Boolean)Palladium.CONFIG.chunkOptimizations.get()).booleanValue()) {
            this.structureStarts.computeIfAbsent(structure, s -> start);
            this.palladium$isUnsaved.set(true);
            ci.cancel();
        }
    }

    @Inject(method={"addReferenceForStructure"}, at={@At(value="HEAD")}, cancellable=true)
    public void addRef(Structure structure, long reference, CallbackInfo ci) {
        if (((Boolean)Palladium.CONFIG.chunkOptimizations.get()).booleanValue()) {
            this.structuresRefences.computeIfAbsent(structure, s -> new LongOpenHashSet()).add(reference);
            this.palladium$isUnsaved.set(true);
            ci.cancel();
        }
    }

    @Inject(method={"getReferencesForStructure"}, at={@At(value="HEAD")}, cancellable=true)
    public void getUnmodifiableRefsForStructure(Structure structure, CallbackInfoReturnable<LongSet> cir) {
        if (((Boolean)Palladium.CONFIG.chunkOptimizations.get()).booleanValue()) {
            cir.setReturnValue((Object)this.structuresRefences.getOrDefault(structure, (LongSet)EMPTY_REF.get()));
        }
    }

    @Inject(method={"isUnsaved"}, at={@At(value="HEAD")}, cancellable=true)
    public void atomicSetUnsaved(CallbackInfoReturnable<Boolean> cir) {
        if (((Boolean)Palladium.CONFIG.chunkOptimizations.get()).booleanValue()) {
            cir.setReturnValue((Object)this.palladium$isUnsaved.get());
        }
    }

    @Inject(method={"setUnsaved"}, at={@At(value="HEAD")}, cancellable=true)
    public void tryMarkAtomic(boolean unsaved, CallbackInfo ci) {
        if (((Boolean)Palladium.CONFIG.chunkOptimizations.get()).booleanValue()) {
            this.palladium$isUnsaved.set(unsaved);
            ci.cancel();
        }
    }

    @Inject(method={"isUnsaved"}, at={@At(value="RETURN")}, cancellable=true)
    public void atomicUnsaved(CallbackInfoReturnable<Boolean> cir) {
        if (((Boolean)Palladium.CONFIG.chunkOptimizations.get()).booleanValue()) {
            cir.setReturnValue((Object)this.palladium$isUnsaved.get());
        }
    }

    @Inject(method={"setLightCorrect"}, at={@At(value="HEAD")}, cancellable=true)
    public void setLightCorrect(boolean value, CallbackInfo ci) {
        if (((Boolean)Palladium.CONFIG.chunkOptimizations.get()).booleanValue()) {
            this.palladium$lightCorrect.set(value);
            this.palladium$isUnsaved.set(true);
            ci.cancel();
        }
    }

    @Inject(method={"isLightCorrect"}, at={@At(value="RETURN")}, cancellable=true)
    public void atomicLightCorrect(CallbackInfoReturnable<Boolean> cir) {
        if (((Boolean)Palladium.CONFIG.chunkOptimizations.get()).booleanValue()) {
            cir.setReturnValue((Object)this.palladium$lightCorrect.get());
        }
    }

    @Override
    public AtomicBoolean getUnsaved() {
        return this.palladium$isUnsaved;
    }
}

