/*
 * Decompiled with CFR 0.152.
 */
package com.mr_toad.palladium.core.mixin;

import com.mojang.blaze3d.platform.GlStateManager;
import com.mr_toad.palladium.client.shader.ShaderCacheLoader;
import com.mr_toad.palladium.core.Palladium;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={GlStateManager.class})
public abstract class GLStateManagerMixin {
    @Inject(method={"_glGetUniformLocation"}, at={@At(value="RETURN")}, cancellable=true)
    private static void getUniform(int u, CharSequence sequence, CallbackInfoReturnable<Integer> cir) {
        if (!Palladium.isFabulous() && ((Boolean)Palladium.CONFIG.enableShaderUniformCaching.get()).booleanValue()) {
            cir.setReturnValue((Object)ShaderCacheLoader.uniform(u, sequence));
        }
    }

    @Inject(method={"_glGetAttribLocation"}, at={@At(value="RETURN")}, cancellable=true)
    private static void getVertexAttribute(int shader, CharSequence name, CallbackInfoReturnable<Integer> cir) {
        if (((Boolean)Palladium.CONFIG.enableShaderAttributeCaching.get()).booleanValue()) {
            cir.setReturnValue((Object)ShaderCacheLoader.attribute(shader, name));
        }
    }

    @Inject(method={"_getTexLevelParameter"}, at={@At(value="RETURN")}, cancellable=true)
    private static void getMipmapParameter(int id, int level, int name, CallbackInfoReturnable<Integer> cir) {
        if (((Boolean)Palladium.CONFIG.enableMipmapCaching.get()).booleanValue()) {
            cir.setReturnValue((Object)ShaderCacheLoader.mipmap(id, level, name));
        }
    }
}

