/*
 * Decompiled with CFR 0.152.
 */
package com.mr_toad.palladium.core.mixin;

import com.mr_toad.palladium.client.model.ModelResourceLocationProperties;
import com.mr_toad.palladium.core.Palladium;
import com.mr_toad.palladium.core.config.ResourceLocationDeduplication;
import java.util.Arrays;
import net.minecraft.client.resources.model.ModelResourceLocation;
import net.minecraft.resources.ResourceLocation;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Mutable;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={ModelResourceLocation.class})
public abstract class ModelResourceLocationMixin
implements ModelResourceLocationProperties {
    @Mutable
    @Shadow
    @Final
    private String variant;
    @Unique
    private String[] palladium$properties;

    @Inject(method={"<init>"}, at={@At(value="RETURN")})
    private void cacheInit(ResourceLocation id, String variant, CallbackInfo ci) {
        if (Palladium.isResourceDedup(ResourceLocationDeduplication.ONLY_MODEL_RESOURCE_LOCATION)) {
            this.palladium$declareProperties();
            this.variant = String.join((CharSequence)",", this.palladium$properties());
        }
    }

    @Inject(method={"getVariant"}, at={@At(value="RETURN")}, cancellable=true)
    private void getVariantByProperties(CallbackInfoReturnable<String> cir) {
        if (Palladium.isResourceDedup(ResourceLocationDeduplication.ONLY_MODEL_RESOURCE_LOCATION) && this.palladium$properties().length != 0) {
            cir.setReturnValue((Object)String.join((CharSequence)",", this.palladium$properties()));
        }
    }

    @Inject(method={"hashCode"}, at={@At(value="RETURN")}, cancellable=true, expect=3)
    private void hashArray(CallbackInfoReturnable<Integer> cir) {
        if (Palladium.isResourceDedup(ResourceLocationDeduplication.ONLY_MODEL_RESOURCE_LOCATION)) {
            cir.setReturnValue((Object)(31 * (Integer)cir.getReturnValue() + Arrays.hashCode(this.palladium$properties())));
        }
    }

    @Override
    public String[] palladium$properties() {
        return this.palladium$properties;
    }

    @Unique
    private void palladium$declareProperties() {
        if (Palladium.isResourceDedup(ResourceLocationDeduplication.ONLY_MODEL_RESOURCE_LOCATION)) {
            this.palladium$properties = (String[])Arrays.stream(this.variant.split(",")).map(Palladium.PROPERTIES::deduplicate).toArray(String[]::new);
        }
    }
}

