/*
 * Decompiled with CFR 0.152.
 */
package com.mr_toad.palladium.core.mixin;

import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.particle.Particle;
import net.minecraft.client.particle.ParticleEngine;
import net.minecraft.client.particle.TerrainParticle;
import net.minecraft.core.BlockPos;
import net.minecraft.util.Mth;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.neoforged.neoforge.client.extensions.common.IClientBlockExtensions;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={ParticleEngine.class})
public abstract class ParticleEngineMixin {
    @Shadow
    protected ClientLevel level;

    @Shadow
    public abstract void add(Particle var1);

    @Inject(method={"destroy"}, at={@At(value="HEAD")}, cancellable=true)
    public void mapDestroyParticle(BlockPos pos, BlockState state, CallbackInfo ci) {
        if (!state.isAir() && !IClientBlockExtensions.of((BlockState)state).addDestroyEffects(state, (Level)this.level, pos, (ParticleEngine)this)) {
            VoxelShape voxelshape = state.getShape((BlockGetter)this.level, pos);
            voxelshape.forAllBoxes((x, y, z, dx, dy, dz) -> {
                double d1 = Math.min(1.0, dx - x);
                double d2 = Math.min(1.0, dy - y);
                double d3 = Math.min(1.0, dz - z);
                int i = Math.max(2, Mth.ceil((double)(d1 / 0.25)));
                int j = Math.max(2, Mth.ceil((double)(d2 / 0.25)));
                int k = Math.max(2, Mth.ceil((double)(d3 / 0.25)));
                double invI = 1.0 / (double)i;
                double invJ = 1.0 / (double)j;
                double invK = 1.0 / (double)k;
                for (int l = 0; l < i; ++l) {
                    double d4 = ((double)l + 0.5) * invI;
                    double d7 = d4 * d1 + x;
                    double velX = d4 - 0.5;
                    for (int i1 = 0; i1 < j; ++i1) {
                        double d5 = ((double)i1 + 0.5) * invJ;
                        double d8 = d5 * d2 + y;
                        double velY = d5 - 0.5;
                        for (int j1 = 0; j1 < k; ++j1) {
                            double d6 = ((double)j1 + 0.5) * invK;
                            double d9 = d6 * d3 + z;
                            double velZ = d6 - 0.5;
                            this.add((Particle)new TerrainParticle(this.level, (double)pos.getX() + d7, (double)pos.getY() + d8, (double)pos.getZ() + d9, velX, velY, velZ, state, pos).updateSprite(state, pos));
                        }
                    }
                }
            });
            ci.cancel();
        }
    }
}

