/*
 * Decompiled with CFR 0.152.
 */
package com.mr_toad.palladium.core.mixin;

import com.mr_toad.palladium.core.Palladium;
import net.minecraft.core.BlockPos;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.ai.goal.target.TargetGoal;
import net.minecraft.world.level.pathfinder.Node;
import net.minecraft.world.level.pathfinder.Path;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.Redirect;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={TargetGoal.class})
public abstract class TargetGoalMixin {
    @Shadow
    @Final
    protected boolean mustSee;
    @Shadow
    private int reachCacheTime;
    @Shadow
    private int reachCache;
    @Shadow
    @Final
    protected Mob mob;
    @Unique
    private int mm$lastSeeCheck = 0;
    @Unique
    private BlockPos mm$lastTargetPos = BlockPos.ZERO;

    @Shadow
    protected abstract double getFollowDistance();

    @Redirect(method={"canContinueToUse"}, at=@At(value="FIELD", target="Lnet/minecraft/world/entity/ai/goal/target/TargetGoal;mustSee:Z"))
    public boolean redirectToCached(TargetGoal instance) {
        if (((Boolean)Palladium.CONFIG.fastTargetRaycasts.get()).booleanValue() && this.mustSee && --this.mm$lastSeeCheck <= 0) {
            return true;
        }
        return this.mustSee;
    }

    @Inject(method={"canContinueToUse"}, at={@At(value="TAIL")})
    public void recomputeWithCache(CallbackInfoReturnable<Boolean> cir) {
        if (((Boolean)Palladium.CONFIG.fastTargetRaycasts.get()).booleanValue() && this.mm$lastSeeCheck == 0) {
            this.mm$lastSeeCheck = 5;
        }
    }

    @Inject(method={"canReach"}, at={@At(value="HEAD")}, cancellable=true)
    private void canReach(LivingEntity target, CallbackInfoReturnable<Boolean> cir) {
        if (((Boolean)Palladium.CONFIG.fastTargetRaycasts.get()).booleanValue()) {
            int j;
            Path path;
            BlockPos targetPos = target.blockPosition();
            if (targetPos.equals((Object)this.mm$lastTargetPos) && this.reachCacheTime > 0) {
                cir.setReturnValue((Object)(this.reachCache == 1 ? 1 : 0));
            }
            this.mm$lastTargetPos = targetPos;
            this.reachCacheTime = Mth.positiveCeilDiv((int)(20 + this.mob.getRandom().nextInt(20)), (int)2);
            if (this.mob.distanceToSqr((Entity)target) > this.getFollowDistance() * this.getFollowDistance() * 4.0) {
                cir.setReturnValue((Object)false);
            }
            if ((path = this.mob.getNavigation().createPath((Entity)target, 0)) == null) {
                cir.setReturnValue((Object)false);
                return;
            }
            Node node = path.getEndNode();
            if (node == null) {
                cir.setReturnValue((Object)false);
                return;
            }
            int i = node.x - target.getBlockX();
            cir.setReturnValue((Object)((double)(i * i + (j = node.z - target.getBlockZ()) * j) <= 2.25 ? 1 : 0));
        }
    }
}

