/*
 * Decompiled with CFR 0.152.
 */
package com.mr_toad.palladium.client.shader.gl;

import com.mr_toad.palladium.client.PalladiumClient;
import java.util.function.Predicate;
import net.minecraft.class_4494;
import org.jetbrains.annotations.Nullable;
import org.lwjgl.opengl.GL;

public class PalladiumGPUCapabilities {
    @Nullable
    private static VendorContainer VENDOR_CONTAINER;

    public static void init() {
        String vendor = class_4494.method_22088();
        PalladiumClient.LOGGER.info("Trying to get GPU vendor...");
        if (vendor != null) {
            if (vendor.contains("NVIDIA")) {
                VENDOR_CONTAINER = new Nvidia();
            } else if (vendor.contains("AMD")) {
                VENDOR_CONTAINER = new AMD();
            } else if (vendor.contains("INTEL")) {
                VENDOR_CONTAINER = new Intel();
            }
        }
        if (VENDOR_CONTAINER != null) {
            PalladiumClient.LOGGER.info("Palladium found supported GPU vendor : '{}'", (Object)vendor);
            VENDOR_CONTAINER.init();
        } else {
            PalladiumClient.LOGGER.error("Failed to initialize additional palladium capabilities, unknown GPU vendor: '{}'", (Object)vendor);
        }
    }

    public static boolean getNv(Predicate<Nvidia> mapper) {
        Nvidia nv;
        VendorContainer vendorContainer = VENDOR_CONTAINER;
        return vendorContainer instanceof Nvidia && mapper.test(nv = (Nvidia)vendorContainer);
    }

    public static boolean getAMD(Predicate<AMD> mapper) {
        AMD amd;
        VendorContainer vendorContainer = VENDOR_CONTAINER;
        return vendorContainer instanceof AMD && mapper.test(amd = (AMD)vendorContainer);
    }

    public static boolean getIntel(Predicate<Intel> mapper) {
        Intel intel;
        VendorContainer vendorContainer = VENDOR_CONTAINER;
        return vendorContainer instanceof Intel && mapper.test(intel = (Intel)vendorContainer);
    }

    public static class Nvidia
    implements VendorContainer {
        private boolean bindlessTextures = false;

        @Override
        public void init() {
        }

        public boolean isBindlessTextures() {
            return this.bindlessTextures;
        }
    }

    public static interface VendorContainer {
        public void init();
    }

    public static class AMD
    implements VendorContainer {
        private boolean vertexShaderTessellator = false;
        private boolean framebufferMultisampled = false;
        private boolean pinnedMemory = false;
        private boolean qbo = false;

        @Override
        public void init() {
            this.vertexShaderTessellator = GL.getCapabilities().GL_AMD_vertex_shader_tessellator;
            this.framebufferMultisampled = GL.getCapabilities().GL_AMD_framebuffer_multisample_advanced;
            this.pinnedMemory = GL.getCapabilities().GL_AMD_pinned_memory;
            this.qbo = GL.getCapabilities().GL_AMD_query_buffer_object;
        }

        public boolean isVertexShaderTessellator() {
            return this.vertexShaderTessellator;
        }

        public boolean isFramebufferMultisampled() {
            return this.framebufferMultisampled;
        }

        public boolean hasPinnedMemory() {
            return this.pinnedMemory;
        }

        public boolean isQBO() {
            return this.qbo;
        }
    }

    public static class Intel
    implements VendorContainer {
        private boolean cmaa = false;

        @Override
        public void init() {
            this.cmaa = GL.getCapabilities().GL_INTEL_framebuffer_CMAA;
        }

        public boolean isCMAA() {
            return this.cmaa;
        }
    }
}

