/*
 * Decompiled with CFR 0.152.
 */
package top.hendrixshen.magiclib;

import java.util.concurrent.atomic.AtomicReference;
import lombok.Generated;
import org.jetbrains.annotations.Nullable;
import top.hendrixshen.magiclib.SharedConstants;
import top.hendrixshen.magiclib.api.dependency.version.SemanticVersion;

public enum MagicLibVersion {
    VERSION_0_1("0.1"),
    VERSION_0_2("0.2"),
    VERSION_0_3("0.3"),
    VERSION_0_4("0.4"),
    VERSION_0_5("0.5"),
    VERSION_0_6("0.6"),
    VERSION_0_7("0.7"),
    VERSION_0_8("0.8");

    private static final AtomicReference<Object> currentMagicLibVersion;
    private final SemanticVersion semver;
    private final String originalVersion;

    private MagicLibVersion(String versionName) {
        this.originalVersion = versionName.trim();
        this.semver = SemanticVersion.parse(this.originalVersion);
    }

    @Nullable
    public static MagicLibVersion toMagicLibVersion(Object value) {
        if (value == null) {
            return null;
        }
        if (value instanceof MagicLibVersion) {
            return (MagicLibVersion)((Object)value);
        }
        String name = value.toString();
        SemanticVersion semver = SemanticVersion.parse(name);
        for (MagicLibVersion version : MagicLibVersion.values()) {
            if (version.getSemver().getVersionComponent(0) != semver.getVersionComponent(0) || version.getSemver().getVersionComponent(1) != semver.getVersionComponent(1)) continue;
            return version;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Generated
    public static MagicLibVersion getCurrentMagicLibVersion() {
        Object $value = currentMagicLibVersion.get();
        if ($value == null) {
            AtomicReference<Object> atomicReference = currentMagicLibVersion;
            synchronized (atomicReference) {
                $value = currentMagicLibVersion.get();
                if ($value == null) {
                    MagicLibVersion actualValue = MagicLibVersion.toMagicLibVersion(SharedConstants.getMagiclibVersion());
                    $value = actualValue == null ? currentMagicLibVersion : actualValue;
                    currentMagicLibVersion.set($value);
                }
            }
        }
        return (MagicLibVersion)((Object)($value == currentMagicLibVersion ? null : $value));
    }

    @Generated
    public SemanticVersion getSemver() {
        return this.semver;
    }

    @Generated
    public String getOriginalVersion() {
        return this.originalVersion;
    }

    static {
        currentMagicLibVersion = new AtomicReference();
    }
}

