/*
 * Decompiled with CFR 0.152.
 */
package top.hendrixshen.magiclib.api.compat.minecraft.network.chat;

import net.minecraft.network.chat.ClickEvent;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import top.hendrixshen.magiclib.impl.compat.minecraft.network.chat.ClickEventCompatImpl;
import top.hendrixshen.magiclib.util.collect.Provider;

public interface ClickEventCompat
extends Provider<ClickEvent> {
    @NotNull
    public static ClickEventCompat of(ClickEvent clickEvent) {
        return new ClickEventCompatImpl(clickEvent);
    }

    @Deprecated
    @ApiStatus.ScheduledForRemoval
    @NotNull
    public static ClickEventCompat of(ClickEvent.Action action, String string) {
        return ClickEventCompatImpl.of(action, string);
    }

    @NotNull
    public static ClickEvent openUrl(String url) {
        return new ClickEvent(ClickEvent.Action.OPEN_URL, url);
    }

    @NotNull
    public static ClickEventCompat openUrlCompat(String url) {
        return ClickEventCompat.of(ClickEventCompat.openUrl(url));
    }

    @NotNull
    public static ClickEvent openFile(String file) {
        return new ClickEvent(ClickEvent.Action.OPEN_FILE, file);
    }

    @NotNull
    public static ClickEventCompat openFileCompat(String file) {
        return ClickEventCompat.of(ClickEventCompat.openFile(file));
    }

    @NotNull
    public static ClickEvent runCommand(String command) {
        return new ClickEvent(ClickEvent.Action.RUN_COMMAND, command);
    }

    @NotNull
    public static ClickEventCompat runCommandCompat(String command) {
        return ClickEventCompat.of(ClickEventCompat.runCommand(command));
    }

    @NotNull
    public static ClickEvent suggestCommand(String command) {
        return new ClickEvent(ClickEvent.Action.SUGGEST_COMMAND, command);
    }

    @NotNull
    public static ClickEventCompat suggestCommandCompat(String command) {
        return ClickEventCompat.of(ClickEventCompat.suggestCommand(command));
    }

    @NotNull
    public static ClickEvent changePage(String page) {
        return new ClickEvent(ClickEvent.Action.CHANGE_PAGE, page);
    }

    @NotNull
    public static ClickEventCompat changePageCompat(String page) {
        return ClickEventCompat.of(ClickEventCompat.changePage(page));
    }

    @NotNull
    public static ClickEvent copyToClipboard(String text) {
        return new ClickEvent(ClickEvent.Action.COPY_TO_CLIPBOARD, text);
    }

    @NotNull
    public static ClickEventCompat copyToClipboardCompat(String text) {
        return ClickEventCompat.of(ClickEventCompat.copyToClipboard(text));
    }
}

