/*
 * Decompiled with CFR 0.152.
 */
package top.hendrixshen.magiclib.impl.malilib.config.option;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import fi.dy.masa.malilib.config.options.ConfigBase;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import lombok.Generated;
import net.minecraft.core.Vec3i;
import org.jetbrains.annotations.ApiStatus;
import top.hendrixshen.magiclib.MagicLib;
import top.hendrixshen.magiclib.api.malilib.config.option.ConfigVec3iList;
import top.hendrixshen.magiclib.impl.malilib.config.option.MagicConfigVec3i;

@ApiStatus.Experimental
public class MagicConfigVec3iList
extends ConfigBase<MagicConfigVec3iList>
implements ConfigVec3iList {
    private final String translationPrefix;
    private final ImmutableList<Vec3i> defaultVec3iList;
    private final List<Vec3i> vec3iList = Lists.newArrayList();

    public MagicConfigVec3iList(String translationPrefix, String name, ImmutableList<Vec3i> defaultVec3iList) {
        super(null, name, String.format("%s.config.option.%s.comment", translationPrefix, name));
        this.translationPrefix = translationPrefix;
        this.defaultVec3iList = defaultVec3iList;
        this.vec3iList.addAll((Collection<Vec3i>)defaultVec3iList);
    }

    @Override
    public String getPrettyName() {
        return ConfigVec3iList.super.getPrettyName();
    }

    @Override
    public String getConfigGuiDisplayName() {
        return ConfigVec3iList.super.getConfigGuiDisplayName();
    }

    @Override
    public void setVec3iList(List<Vec3i> vec3is) {
        if (!this.vec3iList.equals(vec3is)) {
            this.vec3iList.clear();
            this.vec3iList.addAll(vec3is);
            this.onValueChanged();
        }
    }

    public void resetToDefault() {
        this.setVec3iList((List<Vec3i>)this.defaultVec3iList);
    }

    public boolean isModified() {
        return !this.vec3iList.equals(this.defaultVec3iList);
    }

    public void setValueFromJsonElement(JsonElement element) {
        ArrayList oldValue = Lists.newArrayList(this.vec3iList);
        this.vec3iList.clear();
        try {
            if (element.isJsonArray()) {
                JsonArray array = element.getAsJsonArray();
                for (int i = 0; i < array.size(); ++i) {
                    if (!array.get(i).isJsonObject()) continue;
                    Vec3i vec3i = MagicConfigVec3i.vec3iSerializer.deserializeSafe(array.get(i).getAsJsonObject(), Vec3i.ZERO);
                    this.vec3iList.add(vec3i);
                }
            } else {
                MagicLib.getLogger().warn("Failed to set config value for '{}' from the JSON element '{}'", (Object)this.getName(), (Object)element);
            }
        }
        catch (Exception e) {
            MagicLib.getLogger().warn("Failed to set config value for '{}' from the JSON element '{}'", (Object)this.getName(), (Object)element, (Object)e);
        }
        if (!oldValue.equals(this.getVec3iList())) {
            this.onValueChanged(true);
        }
    }

    public JsonElement getAsJsonElement() {
        JsonArray array = new JsonArray();
        for (Vec3i vec3i : this.vec3iList) {
            JsonObject obj = MagicConfigVec3i.vec3iSerializer.serialize(vec3i);
            array.add((JsonElement)obj);
        }
        return array;
    }

    public void onValueChanged() {
        this.onValueChanged(false);
    }

    @Override
    public void onValueChanged(boolean fromFile) {
        super.onValueChanged();
        if (!fromFile && this.getMagicContainer().shouldStatisticValueChange()) {
            this.updateStatisticOnUse();
        }
    }

    @Override
    @Generated
    public String getTranslationPrefix() {
        return this.translationPrefix;
    }

    @Override
    @Generated
    public ImmutableList<Vec3i> getDefaultVec3iList() {
        return this.defaultVec3iList;
    }

    @Override
    @Generated
    public List<Vec3i> getVec3iList() {
        return this.vec3iList;
    }
}

