/*
 * Decompiled with CFR 0.152.
 */
package top.hendrixshen.magiclib.impl.render;

import java.util.Objects;
import net.minecraft.client.Camera;
import net.minecraft.client.Minecraft;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;
import org.joml.Matrix4f;
import org.joml.Quaternionfc;
import top.hendrixshen.magiclib.api.render.context.RenderContext;

public class CameraPositionTransformer {
    private final Vec3 pos;
    private RenderContext context;

    @NotNull
    public static CameraPositionTransformer create(Vec3 pos) {
        return new CameraPositionTransformer(pos);
    }

    private CameraPositionTransformer(Vec3 pos) {
        this.pos = pos;
    }

    public void apply(@NotNull RenderContext context) {
        this.context = context;
        Minecraft mc = Minecraft.getInstance();
        Camera camera = mc.gameRenderer.getMainCamera();
        Vec3 vec3 = this.pos.subtract(camera.getPosition());
        context.pushMatrix();
        context.translate(vec3.x(), vec3.y(), vec3.z());
        context.mulPoseMatrix(new Matrix4f().rotation((Quaternionfc)camera.rotation()));
    }

    public void restore() {
        if (this.context == null) {
            throw new RuntimeException("CameraPositionTransformer: Calling restore before calling apply");
        }
        this.context.popMatrix();
        this.context = null;
    }

    public RenderContext getContext() {
        return Objects.requireNonNull(this.context);
    }
}

