/*
 * Decompiled with CFR 0.152.
 */
package top.hendrixshen.magiclib.impl.render;

import com.google.common.collect.Lists;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.math.Transformation;
import java.util.Collections;
import java.util.List;
import java.util.function.BiFunction;
import java.util.function.Function;
import lombok.Generated;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.util.FormattedCharSequence;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;
import org.joml.Matrix4f;
import top.hendrixshen.magiclib.api.render.context.RenderContext;
import top.hendrixshen.magiclib.impl.render.CameraPositionTransformer;
import top.hendrixshen.magiclib.impl.render.context.RenderGlobal;
import top.hendrixshen.magiclib.util.minecraft.PositionUtil;
import top.hendrixshen.magiclib.util.minecraft.render.RenderUtil;
import top.hendrixshen.magiclib.util.minecraft.render.TextRenderUtil;

public class TextRenderer {
    public static final double DEFAULT_FONT_SCALE = 0.025;
    private static final double DEFAULT_LINE_HEIGHT_RATIO = 1.0 * (double)RenderUtil.TEXT_LINE_HEIGHT / (double)RenderUtil.TEXT_HEIGHT;
    private final List<TextHolder> lines = Lists.newArrayList();
    private Vec3 pos;
    private double shiftX = 0.0;
    private double shiftY = 0.0;
    private double fontScale = 0.025;
    private double lineHeightRatio = DEFAULT_LINE_HEIGHT_RATIO;
    private int color = -1;
    private int backgroundColor = 0;
    private boolean shadow = false;
    private boolean seeThrough = false;
    private HorizontalAlignment horizontalAlignment = HorizontalAlignment.DEFAULT;
    private VerticalAlignment verticalAlignment = VerticalAlignment.DEFAULT;

    @NotNull
    public static TextRenderer create() {
        return new TextRenderer();
    }

    @NotNull
    private static RenderContext createGlobalMatrixRenderContext() {
        return RenderContext.of(RenderSystem.getModelViewStack());
    }

    private TextRenderer() {
    }

    public void render() {
        double maxTextWidth;
        if (this.lines.isEmpty()) {
            return;
        }
        Minecraft mc = Minecraft.getInstance();
        RenderContext context = TextRenderer.createGlobalMatrixRenderContext();
        CameraPositionTransformer positionTransformer = CameraPositionTransformer.create(this.pos);
        positionTransformer.apply(context);
        context.scale(this.fontScale * (double)RenderUtil.getSizeScalingXSign(), -this.fontScale, this.fontScale);
        if (this.seeThrough) {
            RenderGlobal.disableDepthTest();
        } else {
            RenderGlobal.enableDepthTest();
        }
        RenderGlobal.depthMask(true);
        int lineNum = this.lines.size();
        double totalTextWidth = maxTextWidth = (double)this.lines.stream().mapToInt(TextHolder::getWidth).max().orElse(0);
        double totalTextHeight = (double)(RenderUtil.TEXT_HEIGHT * lineNum) + (this.lineHeightRatio - 1.0) * (double)(lineNum - 1);
        context.translate(this.horizontalAlignment.getTranslateX(totalTextWidth), this.verticalAlignment.getTranslateY(totalTextHeight), 0.0);
        context.translate(this.shiftX, this.shiftY, 0.0);
        RenderGlobal.enableBlend();
        RenderGlobal.blendFuncForAlpha();
        block0: for (int i = 0; i < lineNum; ++i) {
            TextHolder holder = this.lines.get(i);
            float textX = (float)this.horizontalAlignment.getTextX(maxTextWidth, holder.getWidth());
            float textY = (float)(this.getLineHeight() * (double)i);
            int backgroundColor = this.backgroundColor;
            while (true) {
                MultiBufferSource.BufferSource immediate = RenderUtil.getBufferSource();
                Matrix4f matrix4f = Transformation.identity().getMatrix();
                mc.font.drawInBatch(holder.text, textX, textY, this.color, this.shadow, matrix4f, (MultiBufferSource)immediate, this.seeThrough ? Font.DisplayMode.SEE_THROUGH : Font.DisplayMode.NORMAL, backgroundColor, 0xF000F0);
                immediate.endBatch();
                if (backgroundColor == 0) continue block0;
                backgroundColor = 0;
            }
        }
        positionTransformer.restore();
    }

    private TextRenderer addLines(TextHolder ... lines) {
        Collections.addAll(this.lines, lines);
        return this;
    }

    private TextRenderer setLines(TextHolder ... lines) {
        this.lines.clear();
        this.addLines(lines);
        return this;
    }

    public TextRenderer text(FormattedCharSequence text) {
        return this.setLines(TextHolder.of(text));
    }

    public TextRenderer text(String text) {
        return this.setLines(TextHolder.of(text));
    }

    public TextRenderer text(Component text) {
        return this.setLines(TextHolder.of(text));
    }

    public TextRenderer addLine(FormattedCharSequence text) {
        return this.addLines(TextHolder.of(text));
    }

    public TextRenderer addLine(String text) {
        return this.addLines(TextHolder.of(text));
    }

    public TextRenderer addLine(Component text) {
        return this.addLines(TextHolder.of(text));
    }

    public TextRenderer lineHeightRatio(double lineHeightRatio) {
        this.lineHeightRatio = lineHeightRatio;
        return this;
    }

    public TextRenderer at(Vec3 vec3) {
        this.pos = vec3;
        return this;
    }

    public TextRenderer at(double x, double y, double z) {
        return this.at(new Vec3(x, y, z));
    }

    public TextRenderer atCenter(BlockPos blockPos) {
        return this.at(PositionUtil.centerOf(blockPos));
    }

    public TextRenderer shift(double x, double y) {
        this.shiftX = x;
        this.shiftY = y;
        return this;
    }

    public TextRenderer fontScale(double fontScale) {
        this.fontScale = fontScale;
        return this;
    }

    public TextRenderer color(int color) {
        this.color = color;
        return this;
    }

    public TextRenderer bgColor(int backgroundColor) {
        this.backgroundColor = backgroundColor;
        return this;
    }

    public TextRenderer color(int color, int backgroundColor) {
        this.color(color);
        this.bgColor(backgroundColor);
        return this;
    }

    public TextRenderer shadow(boolean shadow) {
        this.shadow = shadow;
        return this;
    }

    public TextRenderer shadow() {
        return this.shadow(true);
    }

    public TextRenderer seeThrough(boolean seeThrough) {
        this.seeThrough = seeThrough;
        return this;
    }

    public TextRenderer seeThrough() {
        return this.seeThrough(true);
    }

    public TextRenderer align(HorizontalAlignment horizontalAlignment) {
        this.horizontalAlignment = horizontalAlignment;
        return this;
    }

    public TextRenderer align(VerticalAlignment verticalAlignment) {
        this.verticalAlignment = verticalAlignment;
        return this;
    }

    public double getLineHeight() {
        return (double)RenderUtil.TEXT_HEIGHT * this.lineHeightRatio;
    }

    @Generated
    public Vec3 getPos() {
        return this.pos;
    }

    public static enum HorizontalAlignment {
        LEFT(w -> 0.0, (w, tw) -> 0.0),
        RIGHT(w -> -w.doubleValue(), (w, tw) -> w - tw),
        CENTER(w -> -0.5 * w, (w, tw) -> 0.5 * (w - tw));

        public static final HorizontalAlignment DEFAULT;
        private final Function<Double, Double> trMapper;
        private final BiFunction<Double, Double, Double> posMapper;

        private HorizontalAlignment(Function<Double, Double> trMapper, BiFunction<Double, Double, Double> posMapper) {
            this.trMapper = trMapper;
            this.posMapper = posMapper;
        }

        public double getTranslateX(double width) {
            return this.trMapper.apply(width);
        }

        public double getTextX(double width, double textWidth) {
            return this.posMapper.apply(width, textWidth);
        }

        static {
            DEFAULT = CENTER;
        }
    }

    public static enum VerticalAlignment {
        TOP(h -> 0.0),
        BOTTOM(h -> -h.doubleValue()),
        CENTER(h -> -0.5 * h);

        private final Function<Double, Double> trMapper;
        public static final VerticalAlignment DEFAULT;

        private VerticalAlignment(Function<Double, Double> trMapper) {
            this.trMapper = trMapper;
        }

        public double getTranslateY(double height) {
            return this.trMapper.apply(height);
        }

        static {
            DEFAULT = CENTER;
        }
    }

    private static class TextHolder {
        public final FormattedCharSequence text;

        private TextHolder(FormattedCharSequence text) {
            this.text = text;
        }

        @NotNull
        public static TextHolder of(FormattedCharSequence text) {
            return new TextHolder(text);
        }

        @NotNull
        public static TextHolder of(String text) {
            return TextHolder.of(TextRenderUtil.string2formattedCharSequence(text));
        }

        @NotNull
        public static TextHolder of(@NotNull Component text) {
            return new TextHolder(text.getVisualOrderText());
        }

        public int getWidth() {
            return RenderUtil.getRenderWidth(this.text);
        }
    }
}

