/*
 * Decompiled with CFR 0.152.
 */
package top.hendrixshen.magiclib.api.compat.minecraft.client.gui.components;

import java.util.function.Supplier;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.Tooltip;
import net.minecraft.network.chat.Component;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import top.hendrixshen.magiclib.api.compat.minecraft.network.chat.ComponentCompat;
import top.hendrixshen.magiclib.api.compat.minecraft.network.chat.MutableComponentCompat;
import top.hendrixshen.magiclib.util.collect.Provider;

@OnlyIn(value=Dist.CLIENT)
public interface ButtonCompat
extends Provider<Button> {
    public static @NotNull Builder builder(@NotNull Component message, @NotNull OnPress onPress) {
        return new Builder(message, onPress);
    }

    public static @NotNull Builder builder(@NotNull ComponentCompat message, @NotNull OnPress onPress) {
        return new Builder((Component)message.get(), onPress);
    }

    @OnlyIn(value=Dist.CLIENT)
    public static class Builder {
        private final Button.Builder builder;
        private int width = 150;

        public Builder(@NotNull Component message, @NotNull OnPress onPress) {
            this.builder = new Button.Builder(message, onPress::onPress);
        }

        public Builder pos(int x, int y) {
            this.builder.m_252794_(x, y);
            return this;
        }

        public Builder width(int width) {
            this.width = width;
            this.builder.m_252780_(width);
            return this;
        }

        public Builder height(int height) {
            return this.size(this.width, height);
        }

        public Builder size(int width, int height) {
            this.builder.m_253046_(width, height);
            return this;
        }

        public Builder bounds(int x, int y, int width, int height) {
            this.builder.m_252987_(x, y, width, height);
            return this;
        }

        public Builder tooltip(@Nullable Tooltip tooltip) {
            this.builder.m_257505_(tooltip);
            return this;
        }

        public Builder createNarration(Button.CreateNarration narration) {
            this.builder.m_252778_(narration);
            return this;
        }

        public Button build() {
            return this.builder.m_253136_();
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public static interface OnPress {
        public void onPress(Button var1);
    }

    @OnlyIn(value=Dist.CLIENT)
    public static interface CreateNarration {
        public MutableComponentCompat createNarrationMessage(Supplier<MutableComponentCompat> var1);
    }
}

