/*
 * Decompiled with CFR 0.152.
 */
package top.hendrixshen.magiclib.impl.event.minecraft.render;

import com.mojang.blaze3d.vertex.PoseStack;
import java.util.List;
import lombok.Generated;
import net.minecraft.world.entity.Entity;
import org.jetbrains.annotations.NotNull;
import top.hendrixshen.magiclib.api.compat.minecraft.util.ProfilerCompat;
import top.hendrixshen.magiclib.api.event.Event;
import top.hendrixshen.magiclib.api.event.minecraft.render.RenderEntityListener;
import top.hendrixshen.magiclib.api.render.context.RenderContext;
import top.hendrixshen.magiclib.impl.render.matrix.MinecraftPoseStack;
import top.hendrixshen.magiclib.util.minecraft.render.RenderUtil;

public class RenderEntityEvent {
    private static EntityRenderContext fromInfo(Info info) {
        return EntityRenderContext.of(info.entity, info.renderContext.getMatrixStack().getPoseStack(), 0.0f);
    }

    public static class Info {
        @NotNull
        private final Entity entity;
        @NotNull
        private final top.hendrixshen.magiclib.impl.render.context.EntityRenderContext renderContext;

        public static Info of(Entity entity, PoseStack poseStack) {
            return new Info(entity, new top.hendrixshen.magiclib.impl.render.context.EntityRenderContext(new MinecraftPoseStack(poseStack)));
        }

        @Generated
        private Info(@NotNull Entity entity, @NotNull top.hendrixshen.magiclib.impl.render.context.EntityRenderContext renderContext) {
            if (entity == null) {
                throw new NullPointerException("entity is marked non-null but is null");
            }
            if (renderContext == null) {
                throw new NullPointerException("renderContext is marked non-null but is null");
            }
            this.entity = entity;
            this.renderContext = renderContext;
        }
    }

    public static class EntityRenderContext {
        private final Entity entity;
        private final RenderContext renderContext;
        private final float partialTicks;

        @NotNull
        public static EntityRenderContext of(Entity entity, PoseStack poseStack, float partialTicks) {
            return new EntityRenderContext(entity, RenderContext.of(poseStack), partialTicks);
        }

        @Generated
        private EntityRenderContext(Entity entity, RenderContext renderContext, float partialTicks) {
            this.entity = entity;
            this.renderContext = renderContext;
            this.partialTicks = partialTicks;
        }
    }

    public static class PostRender
    implements Event<RenderEntityListener> {
        private final EntityRenderContext context;
        private final Info info;

        public PostRender(Info info) {
            this.info = info;
            this.context = RenderEntityEvent.fromInfo(info);
        }

        @Override
        public void dispatch(@NotNull List<RenderEntityListener> listeners) {
            ProfilerCompat.get().m_6180_("Magiclib#PostEntityRenderHook");
            for (RenderEntityListener listener : listeners) {
                try {
                    listener.postRenderEntity(this.info.entity, this.info.renderContext);
                }
                catch (UnsupportedOperationException e) {
                    listener.postRenderEntity(this.context.entity, this.context.renderContext, RenderUtil.getPartialTick());
                }
            }
            ProfilerCompat.get().m_7238_();
        }

        @Override
        public Class<RenderEntityListener> getListenerType() {
            return RenderEntityListener.class;
        }
    }

    public static class PreRender
    implements Event<RenderEntityListener> {
        private final EntityRenderContext context;
        private final Info info;

        public PreRender(Info info) {
            this.info = info;
            this.context = RenderEntityEvent.fromInfo(info);
        }

        @Override
        public void dispatch(@NotNull List<RenderEntityListener> listeners) {
            ProfilerCompat.get().m_6180_("Magiclib#PreEntityRenderHook");
            for (RenderEntityListener listener : listeners) {
                try {
                    listener.preRenderEntity(this.info.entity, this.info.renderContext);
                }
                catch (UnsupportedOperationException e) {
                    listener.preRenderEntity(this.context.entity, this.context.renderContext, RenderUtil.getPartialTick());
                }
            }
            ProfilerCompat.get().m_7238_();
        }

        @Override
        public Class<RenderEntityListener> getListenerType() {
            return RenderEntityListener.class;
        }
    }
}

