/*
 * Decompiled with CFR 0.152.
 */
package top.hendrixshen.magiclib.util;

import java.util.Collection;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import top.hendrixshen.magiclib.MagicLib;
import top.hendrixshen.magiclib.api.dependency.version.SemanticVersion;
import top.hendrixshen.magiclib.api.dependency.version.VersionParsingException;
import top.hendrixshen.magiclib.api.i18n.I18n;
import top.hendrixshen.magiclib.impl.dependency.version.VersionPredicateParser;

public class VersionUtil {
    @Contract(pure=true)
    public static boolean isVersionSatisfyPredicates(String version, @NotNull Collection<String> versionPredicates) {
        return versionPredicates.isEmpty() || versionPredicates.stream().allMatch(versionPredicate -> VersionUtil.isVersionSatisfyPredicate(version, versionPredicate));
    }

    public static boolean isVersionSatisfyPredicate(String version, String versionPredicate) {
        SemanticVersion semver;
        try {
            semver = SemanticVersion.parse(version);
        }
        catch (VersionParsingException e) {
            MagicLib.getLogger().error("Failed to parse version {}: {}", (Object)version, (Object)e);
            return false;
        }
        try {
            return VersionPredicateParser.parse(versionPredicate).test(semver);
        }
        catch (VersionParsingException e) {
            MagicLib.getLogger().error("Failed to parse version predicate {}: {}", (Object)versionPredicate, (Object)e);
            return false;
        }
    }

    @NotNull
    public static String getVersionType(@NotNull String version) {
        return VersionUtil.translateVersionType(version, "en_us");
    }

    @NotNull
    public static String translateVersionType(@NotNull String version) {
        return VersionUtil.translateVersionType(version, I18n.getCurrentLanguageCode());
    }

    @NotNull
    public static String translateVersionType(@NotNull String version, String languageCode) {
        if (version.endsWith("beta")) {
            return I18n.trByCode(languageCode, "magiclib.misc.version_type.beta");
        }
        if (version.endsWith("dev")) {
            return I18n.trByCode(languageCode, "magiclib.misc.version_type.development");
        }
        if (version.endsWith("fork")) {
            return I18n.trByCode(languageCode, "magiclib.misc.version_type.fork");
        }
        if (version.endsWith("pull_request")) {
            return I18n.trByCode(languageCode, "magiclib.misc.version_type.pull_request");
        }
        if (version.endsWith("stable")) {
            return I18n.trByCode(languageCode, "magiclib.misc.version_type.stable");
        }
        return I18n.trByCode(languageCode, "magiclib.misc.version_type.unknown");
    }
}

