/*
 * Decompiled with CFR 0.152.
 */
package top.hendrixshen.magiclib.impl.malilib.config.gui.widget;

import fi.dy.masa.malilib.gui.GuiTextFieldGeneric;
import fi.dy.masa.malilib.gui.button.ButtonBase;
import fi.dy.masa.malilib.gui.button.ButtonGeneric;
import fi.dy.masa.malilib.gui.button.IButtonActionListener;
import fi.dy.masa.malilib.gui.interfaces.IGuiIcon;
import fi.dy.masa.malilib.gui.widgets.WidgetConfigOptionBase;
import fi.dy.masa.malilib.gui.widgets.WidgetListConfigOptionsBase;
import fi.dy.masa.malilib.render.RenderUtils;
import java.util.Collections;
import java.util.List;
import lombok.Generated;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.core.Vec3i;
import top.hendrixshen.magiclib.api.malilib.config.option.ConfigVec3iList;
import top.hendrixshen.magiclib.impl.malilib.config.gui.button.ListEditEntryButtonType;
import top.hendrixshen.magiclib.impl.malilib.config.gui.widget.WidgetListVec3iListEdit;
import top.hendrixshen.magiclib.impl.malilib.config.gui.widget.WidgetVec3iEdit;

public class WidgetVec3iListEditEntry
extends WidgetConfigOptionBase<Vec3i> {
    protected final WidgetListVec3iListEdit parent;
    protected final Vec3i defaultValue;
    protected Vec3i initialValue;
    protected Vec3i lastAppliedValue;
    protected final int listIndex;
    protected final boolean isOdd;
    protected final WidgetVec3iEntry vec3iEntry;

    public WidgetVec3iListEditEntry(int x, int y, int width, int height, int listIndex, boolean isOdd, Vec3i initialValue, Vec3i defaultValue, WidgetListVec3iListEdit parent) {
        super(x, y, width, height, (WidgetListConfigOptionsBase)parent, (Object)initialValue, listIndex);
        this.listIndex = listIndex;
        this.isOdd = isOdd;
        this.defaultValue = defaultValue;
        this.initialValue = initialValue;
        this.lastAppliedValue = initialValue;
        this.parent = parent;
        int iy = ++y + 3;
        if (!this.isDummy()) {
            this.addLabel(x + 2, y, 20, 20, -1061109568, new String[]{String.format("%3d:", listIndex + 1)});
            int vec3iWidth = width - 120;
            this.vec3iEntry = new WidgetVec3iEntry(x += 20, y, vec3iWidth, height, initialValue, defaultValue);
            this.vec3iEntry.getTextFields().forEach(arg_0 -> ((WidgetListVec3iListEdit)this.parent).addTextField(arg_0));
            this.addListActionButton(x += vec3iWidth + 2, iy, ListEditEntryButtonType.ADD);
            this.addListActionButton(x += 18, iy, ListEditEntryButtonType.REMOVE);
            x += 18;
            if (this.canBeMoved(true)) {
                this.addListActionButton(x, iy, ListEditEntryButtonType.MOVE_DOWN);
            }
            x += 18;
            if (this.canBeMoved(false)) {
                this.addListActionButton(x, iy, ListEditEntryButtonType.MOVE_UP);
            }
        } else {
            this.vec3iEntry = null;
            this.addListActionButton(x, y + 3, ListEditEntryButtonType.ADD);
        }
    }

    protected boolean isDummy() {
        return this.listIndex < 0;
    }

    protected void addListActionButton(int x, int y, ListEditEntryButtonType type) {
        ButtonGeneric button = new ButtonGeneric(x, y, (IGuiIcon)type.getIcon(), new String[]{type.getDisplayName()});
        ListenerListActions listener = new ListenerListActions(type, this);
        this.addButton((ButtonBase)button, listener);
    }

    protected GuiTextFieldGeneric createTextField(int x, int y, int width, int height) {
        return null;
    }

    public boolean wasConfigModified() {
        if (this.isDummy()) {
            return false;
        }
        return this.vec3iEntry.wasConfigModified();
    }

    public boolean hasPendingModifications() {
        if (this.isDummy()) {
            return false;
        }
        return !this.vec3iEntry.getVec3iValue().equals((Object)this.vec3iEntry.lastAppliedValue);
    }

    public void applyNewValueToConfig() {
        if (!this.isDummy()) {
            ConfigVec3iList config = this.parent.getParent().getConfig();
            List<Vec3i> list = config.getVec3iList();
            Vec3i newValue = this.vec3iEntry.getVec3iValue();
            if (list.size() > this.listIndex) {
                list.set(this.listIndex, newValue);
                this.vec3iEntry.lastAppliedValue = newValue;
            }
        }
    }

    private void insertEntryBefore() {
        List<Vec3i> list = this.parent.getParent().getConfig().getVec3iList();
        int size = list.size();
        int index = this.listIndex < 0 ? size : Math.min(this.listIndex, size);
        list.add(index, Vec3i.ZERO);
        this.parent.refreshEntries();
        this.parent.markConfigsModified();
    }

    private void removeEntry() {
        List<Vec3i> list = this.parent.getParent().getConfig().getVec3iList();
        int size = list.size();
        if (this.listIndex >= 0 && this.listIndex < size) {
            list.remove(this.listIndex);
            this.parent.refreshEntries();
            this.parent.markConfigsModified();
        }
    }

    private void moveEntry(boolean down) {
        List<Vec3i> list = this.parent.getParent().getConfig().getVec3iList();
        int size = list.size();
        if (this.listIndex >= 0 && this.listIndex < size) {
            int index1 = this.listIndex;
            int index2 = -1;
            if (down && this.listIndex < size - 1) {
                index2 = index1 + 1;
            } else if (!down && this.listIndex > 0) {
                index2 = index1 - 1;
            }
            if (index2 >= 0) {
                this.parent.markConfigsModified();
                this.parent.applyPendingModifications();
                Collections.swap(list, index1, index2);
                this.parent.refreshEntries();
            }
        }
    }

    private boolean canBeMoved(boolean down) {
        int size = this.parent.getParent().getConfig().getVec3iList().size();
        return this.listIndex >= 0 && this.listIndex < size && (down && this.listIndex < size - 1 || !down && this.listIndex > 0);
    }

    public void render(GuiGraphics guiGraphics, int mouseX, int mouseY, boolean selected) {
        if (this.isOdd) {
            RenderUtils.drawRect((GuiGraphics)guiGraphics, (int)this.x, (int)this.y, (int)this.width, (int)this.height, (int)0x20FFFFFF);
        } else {
            RenderUtils.drawRect((GuiGraphics)guiGraphics, (int)this.x, (int)this.y, (int)this.width, (int)this.height, (int)0x30FFFFFF);
        }
        this.drawSubWidgets(guiGraphics, mouseX, mouseY);
        if (this.vec3iEntry != null) {
            this.vec3iEntry.render(guiGraphics, mouseX, mouseY, selected);
        }
        super.render(guiGraphics, mouseX, mouseY, selected);
    }

    protected boolean onMouseClickedImpl(int mouseX, int mouseY, int mouseButton) {
        if (super.onMouseClickedImpl(mouseX, mouseY, mouseButton)) {
            return true;
        }
        if (this.vec3iEntry == null) {
            return false;
        }
        return this.vec3iEntry.onMouseClickedImpl(mouseX, mouseY, mouseButton);
    }

    public boolean onKeyTypedImpl(int keyCode, int scanCode, int modifiers) {
        if (this.vec3iEntry == null) {
            return false;
        }
        return this.vec3iEntry.onKeyTypedImpl(keyCode, scanCode, modifiers);
    }

    protected boolean onCharTypedImpl(char charIn, int modifiers) {
        if (this.vec3iEntry == null) {
            return false;
        }
        return this.vec3iEntry.onCharTypedImpl(charIn, modifiers);
    }

    protected static class WidgetVec3iEntry
    extends WidgetVec3iEdit {
        public WidgetVec3iEntry(int x, int y, int width, int height, Vec3i initialValue, Vec3i defaultValue) {
            super(x, y, width, height, initialValue, defaultValue, null);
        }
    }

    private static class ListenerListActions
    implements IButtonActionListener {
        private final ListEditEntryButtonType type;
        private final WidgetVec3iListEditEntry parent;

        public void actionPerformedWithButton(ButtonBase button, int mouseButton) {
            if (this.type == ListEditEntryButtonType.ADD) {
                this.parent.insertEntryBefore();
            } else if (this.type == ListEditEntryButtonType.REMOVE) {
                this.parent.removeEntry();
            } else {
                this.parent.moveEntry(this.type == ListEditEntryButtonType.MOVE_DOWN);
            }
        }

        @Generated
        public ListenerListActions(ListEditEntryButtonType type, WidgetVec3iListEditEntry parent) {
            this.type = type;
            this.parent = parent;
        }
    }
}

